/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geotools.image.util.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.Resource;
import org.geowebcache.io.codec.ImageDecoderContainer;
import org.geowebcache.io.codec.ImageEncoderContainer;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.wms.BufferedImageWrapper;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.AccountingOutputStream;
import org.geowebcache.util.IOUtils;
import org.geowebcache.util.ServletUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class WMSTileFuser {
    private static Logger log = Logging.getLogger((String)WMSTileFuser.class.getName());
    private ApplicationContext applicationContext;
    final StorageBroker sb;
    final GridSubset gridSubset;
    final TileLayer layer;
    final ImageMime outputFormat;
    ImageMime srcFormat;
    int reqHeight;
    int reqWidth;
    final BoundingBox reqBounds;
    double xResolution;
    double yResolution;
    double srcResolution;
    int srcIdx;
    long[] srcRectangle;
    BoundingBox srcBounds;
    BoundingBox canvasBounds;
    int[] canvasSize = new int[2];
    BufferedImageWrapper bufferedImageWrapper;
    PixelOffsets canvOfs = new PixelOffsets();
    SpatialOffsets boundOfs = new SpatialOffsets();
    private Map<String, String> fullParameters;
    private ImageDecoderContainer decoderMap;
    private ImageEncoderContainer encoderMap;
    private RenderingHints hints;
    private SecurityDispatcher securityDispatcher;

    protected WMSTileFuser(TileLayerDispatcher tld, StorageBroker sb, HttpServletRequest servReq) throws GeoWebCacheException {
        this.sb = sb;
        String[] keys = new String[]{"layers", "format", "srs", "bbox", "width", "height", "transparent", "bgcolor", "hints"};
        Map values = ServletUtils.selectedStringsFromMap((Map)servReq.getParameterMap(), (String)servReq.getCharacterEncoding(), (String[])keys);
        String layerName = (String)values.get("layers");
        this.layer = tld.getTileLayer(layerName);
        this.gridSubset = this.layer.getGridSubsetForSRS(SRS.getSRS((String)((String)values.get("srs"))));
        this.outputFormat = (ImageMime)ImageMime.createFromFormat((String)((String)values.get("format")));
        List ml = this.layer.getMimeTypes();
        Iterator iter = ml.iterator();
        ImageMime firstMt = null;
        if (iter.hasNext()) {
            firstMt = (ImageMime)iter.next();
        }
        boolean outputGif = this.outputFormat.getInternalName().equalsIgnoreCase("gif");
        while (iter.hasNext()) {
            MimeType mt = (MimeType)iter.next();
            if (outputGif && mt.getInternalName().equalsIgnoreCase("gif")) {
                this.srcFormat = (ImageMime)mt;
                break;
            }
            if (!mt.getInternalName().equalsIgnoreCase("png")) continue;
            this.srcFormat = (ImageMime)mt;
        }
        if (this.srcFormat == null) {
            this.srcFormat = firstMt;
        }
        this.reqBounds = new BoundingBox((String)values.get("bbox"));
        this.reqWidth = Integer.valueOf((String)values.get("width"));
        this.reqHeight = Integer.valueOf((String)values.get("height"));
        this.fullParameters = this.layer.getModifiableParameters(servReq.getParameterMap(), servReq.getCharacterEncoding());
        if (values.get("hints") != null) {
            this.hints = HintsLevel.getHintsForMode((String)values.get("hints")).getRenderingHints();
        }
    }

    @Deprecated
    protected WMSTileFuser(TileLayer layer, GridSubset gridSubset, BoundingBox bounds, int width, int height) {
        this.sb = null;
        this.outputFormat = ImageMime.png;
        this.layer = layer;
        this.gridSubset = gridSubset;
        this.reqBounds = bounds;
        this.reqWidth = width;
        this.reqHeight = height;
        this.fullParameters = Collections.emptyMap();
        List ml = layer.getMimeTypes();
        Iterator iter = ml.iterator();
        ImageMime firstMt = null;
        if (iter.hasNext()) {
            firstMt = (ImageMime)iter.next();
        }
        while (iter.hasNext()) {
            MimeType mt = (MimeType)iter.next();
            if (!mt.getInternalName().equalsIgnoreCase("png")) continue;
            this.srcFormat = (ImageMime)mt;
            break;
        }
        if (this.srcFormat == null) {
            this.srcFormat = firstMt;
        }
    }

    protected void determineSourceResolution() {
        this.xResolution = this.reqBounds.getWidth() / (double)this.reqWidth;
        this.yResolution = this.reqBounds.getHeight() / (double)this.reqHeight;
        double tmpResolution = this.yResolution < this.xResolution ? this.yResolution : this.xResolution;
        log.fine("x res: " + this.xResolution + " y res: " + this.yResolution + " tmpResolution: " + tmpResolution);
        double compResolution = 1.005 * tmpResolution;
        double[] resArray = this.gridSubset.getResolutions();
        this.srcIdx = 0;
        while (this.srcIdx < resArray.length) {
            this.srcResolution = resArray[this.srcIdx];
            if (this.srcResolution < compResolution) break;
            ++this.srcIdx;
        }
        if (this.srcIdx >= resArray.length) {
            this.srcIdx = resArray.length - 1;
        }
        log.fine("z: " + this.srcIdx + " , resolution: " + this.srcResolution + " (" + tmpResolution + ")");
    }

    protected void determineCanvasLayout() {
        this.srcRectangle = this.gridSubset.getCoverageIntersection(this.srcIdx, this.reqBounds);
        this.srcBounds = this.gridSubset.boundsFromRectangle(this.srcRectangle);
        this.boundOfs.left = this.srcBounds.getMinX() - this.reqBounds.getMinX();
        this.boundOfs.bottom = this.srcBounds.getMinY() - this.reqBounds.getMinY();
        this.boundOfs.right = this.reqBounds.getMaxX() - this.srcBounds.getMaxX();
        this.boundOfs.top = this.reqBounds.getMaxY() - this.srcBounds.getMaxY();
        this.canvasSize[0] = (int)Math.round(this.reqBounds.getWidth() / this.srcResolution);
        this.canvasSize[1] = (int)Math.round(this.reqBounds.getHeight() / this.srcResolution);
        PixelOffsets naiveOfs = new PixelOffsets();
        naiveOfs.left = (int)Math.round(this.boundOfs.left / this.srcResolution);
        naiveOfs.bottom = (int)Math.round(this.boundOfs.bottom / this.srcResolution);
        naiveOfs.right = (int)Math.round(this.boundOfs.right / this.srcResolution);
        naiveOfs.top = (int)Math.round(this.boundOfs.top / this.srcResolution);
        int tileWidth = this.gridSubset.getTileWidth();
        int tileHeight = this.gridSubset.getTileHeight();
        this.canvOfs.left = naiveOfs.left;
        this.canvOfs.bottom = naiveOfs.bottom;
        this.canvOfs.right = (this.canvasSize[0] - this.canvOfs.left) % tileWidth;
        this.canvOfs.right = (Integer.signum(naiveOfs.right) * tileWidth + this.canvOfs.right) % tileWidth;
        this.canvOfs.right = this.canvOfs.right - naiveOfs.right % tileWidth + naiveOfs.right;
        this.canvOfs.top = (this.canvasSize[1] - this.canvOfs.bottom) % tileHeight;
        this.canvOfs.top = (Integer.signum(naiveOfs.top) * tileHeight + this.canvOfs.top) % tileHeight;
        this.canvOfs.top = this.canvOfs.top - naiveOfs.top % tileHeight + naiveOfs.top;
        assert (Math.abs(this.canvOfs.left - naiveOfs.left) <= 1);
        assert (Math.abs(this.canvOfs.bottom - naiveOfs.bottom) <= 1);
        assert (Math.abs(this.canvOfs.right - naiveOfs.right) <= 1);
        assert (Math.abs(this.canvOfs.top - naiveOfs.top) <= 1);
        if (log.isLoggable(Level.FINE)) {
            log.fine("intersection rectangle: " + Arrays.toString(this.srcRectangle));
            log.fine("intersection bounds: " + this.srcBounds + " (" + this.reqBounds + ")");
            log.fine("Bound offsets: " + Arrays.toString(new double[]{this.boundOfs.left, this.boundOfs.bottom, this.boundOfs.right, this.boundOfs.top}));
            log.fine("Canvas size: " + Arrays.toString(this.canvasSize) + "(" + this.reqWidth + "," + this.reqHeight + ")");
            log.fine("Canvas offsets: " + Arrays.toString(new int[]{this.canvOfs.left, this.canvOfs.bottom, this.canvOfs.right, this.canvOfs.top}));
        }
    }

    protected void createCanvas() {
        int canvasType;
        Color bgColor = null;
        boolean transparent = true;
        if (this.layer instanceof WMSLayer) {
            WMSLayer wmsLayer = (WMSLayer)this.layer;
            int[] colorAr = wmsLayer.getBackgroundColor();
            if (colorAr != null) {
                bgColor = new Color(colorAr[0], colorAr[1], colorAr[2]);
            }
            transparent = wmsLayer.getTransparent();
        }
        if (bgColor == null && transparent && (this.outputFormat.supportsAlphaBit() || this.outputFormat.supportsAlphaChannel())) {
            canvasType = 2;
        } else {
            canvasType = 1;
            if (bgColor == null) {
                bgColor = Color.WHITE;
            }
        }
        this.bufferedImageWrapper = new BufferedImageWrapper(this.canvasSize, canvasType, bgColor, this.hints);
    }

    protected void renderCanvas() throws OutsideCoverageException, GeoWebCacheException, IOException, Exception {
        long starty;
        for (long gridy = starty = this.srcRectangle[1]; gridy <= this.srcRectangle[3]; ++gridy) {
            long startx;
            int tiley = 0;
            int canvasy = (int)(this.srcRectangle[3] - gridy) * this.gridSubset.getTileHeight();
            int tileHeight = this.gridSubset.getTileHeight();
            if (this.canvOfs.top > 0) {
                canvasy += this.canvOfs.top;
            } else if (gridy == this.srcRectangle[3]) {
                tileHeight += this.canvOfs.top;
                tiley = -this.canvOfs.top;
            } else {
                canvasy += this.canvOfs.top;
            }
            if (gridy == this.srcRectangle[1] && this.canvOfs.bottom < 0) {
                tileHeight += this.canvOfs.bottom;
            }
            for (long gridx = startx = this.srcRectangle[0]; gridx <= this.srcRectangle[2]; ++gridx) {
                long[] gridLoc = new long[]{gridx, gridy, this.srcIdx};
                ConveyorTile tile = new ConveyorTile(this.sb, this.layer.getName(), this.gridSubset.getName(), gridLoc, (MimeType)this.srcFormat, this.fullParameters, null, null);
                tile.setTileLayer(this.layer);
                this.securityDispatcher.checkSecurity(tile);
                try {
                    this.layer.applyRequestFilters(tile);
                }
                catch (RequestFilterException e) {
                    log.log(Level.FINE, e.getMessage(), e);
                    continue;
                }
                this.layer.getTile(tile);
                Resource blob = tile.getBlob();
                String formatName = this.srcFormat.getMimeType();
                BufferedImage tileImg = this.decoderMap.decode(formatName, blob, this.decoderMap.isAggressiveInputStreamSupported(formatName), null);
                int tilex = 0;
                int canvasx = (int)(gridx - startx) * this.gridSubset.getTileWidth();
                int tileWidth = this.gridSubset.getTileWidth();
                if (this.canvOfs.left > 0) {
                    canvasx += this.canvOfs.left;
                } else if (gridx == this.srcRectangle[0]) {
                    tileWidth += this.canvOfs.left;
                    tilex = -this.canvOfs.left;
                } else {
                    canvasx += this.canvOfs.left;
                }
                if (gridx == this.srcRectangle[2] && this.canvOfs.right < 0) {
                    tileWidth += this.canvOfs.right;
                }
                if (tileWidth == 0 || tileHeight == 0) {
                    log.fine("tileWidth: " + tileWidth + " tileHeight: " + tileHeight);
                    continue;
                }
                if (tileWidth != this.gridSubset.getTileWidth() || tileHeight != this.gridSubset.getTileHeight()) {
                    log.fine("tileImg.getSubimage(" + tilex + "," + tiley + "," + tileWidth + "," + tileHeight + ")");
                    tileImg = tileImg.getSubimage(tilex, tiley, tileWidth, tileHeight);
                }
                log.fine("drawImage(subtile," + canvasx + "," + canvasy + ",null) " + Arrays.toString(gridLoc));
                this.bufferedImageWrapper.drawImage(tileImg, canvasx, canvasy);
            }
        }
        if (this.bufferedImageWrapper != null) {
            this.bufferedImageWrapper.disposeGraphics();
        }
    }

    protected void scaleRaster() {
        if (this.bufferedImageWrapper != null && this.canvasSize[0] != this.reqWidth || this.canvasSize[1] != this.reqHeight) {
            BufferedImage preTransform = this.bufferedImageWrapper.getCanvas();
            BufferedImage rescaled = new BufferedImage(this.reqWidth, this.reqHeight, preTransform.getType());
            Graphics2D gfx = rescaled.createGraphics();
            AffineTransform affineTrans = AffineTransform.getScaleInstance((double)this.reqWidth / (double)preTransform.getWidth(), (double)this.reqHeight / (double)preTransform.getHeight());
            log.fine("AffineTransform: " + (double)this.reqWidth / (double)preTransform.getWidth() + "," + (double)this.reqHeight / (double)preTransform.getHeight());
            RenderingHints hintsTemp = HintsLevel.DEFAULT.getRenderingHints();
            if (this.hints != null) {
                hintsTemp = this.hints;
            }
            gfx.addRenderingHints(hintsTemp);
            gfx.drawRenderedImage(preTransform, affineTrans);
            gfx.dispose();
            this.bufferedImageWrapper.updateCanvas(rescaled);
        }
    }

    protected void writeResponse(HttpServletResponse response, RuntimeStats stats) throws IOException, OutsideCoverageException, GeoWebCacheException, Exception {
        block3: {
            this.determineSourceResolution();
            this.determineCanvasLayout();
            this.createCanvas();
            this.renderCanvas();
            this.scaleRaster();
            AccountingOutputStream aos = null;
            BufferedImage finalImage = null;
            try {
                finalImage = this.bufferedImageWrapper.getCanvas();
                response.setStatus(200);
                response.setContentType(this.outputFormat.getMimeType());
                ServletOutputStream os = response.getOutputStream();
                aos = new AccountingOutputStream(os);
                this.encoderMap.encode(finalImage, (MimeType)this.outputFormat, aos, this.encoderMap.isAggressiveOutputStreamSupported(this.outputFormat.getMimeType()), null);
                log.fine("WMS response size: " + aos.getCount() + "bytes.");
                stats.log(aos.getCount(), Conveyor.CacheResult.WMS);
            }
            catch (Exception e) {
                log.log(Level.FINE, "IOException writing untiled response to client: " + e.getMessage(), e);
                if (aos != null) {
                    IOUtils.closeQuietly(aos);
                }
                if (finalImage == null) break block3;
                ImageUtilities.disposePlanarImageChain((PlanarImage)PlanarImage.wrapRenderedImage((RenderedImage)finalImage));
            }
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
        this.decoderMap = (ImageDecoderContainer)this.applicationContext.getBean(ImageDecoderContainer.class);
        this.encoderMap = (ImageEncoderContainer)this.applicationContext.getBean(ImageEncoderContainer.class);
    }

    public void setHintsConfiguration(String hintsConfig) {
        if (this.hints == null) {
            this.hints = HintsLevel.getHintsForMode(hintsConfig).getRenderingHints();
        }
    }

    public void setSecurityDispatcher(SecurityDispatcher securityDispatcher) {
        this.securityDispatcher = securityDispatcher;
    }

    public static enum HintsLevel {
        QUALITY(0, "quality"),
        DEFAULT(1, "default"),
        SPEED(2, "speed");

        private RenderingHints hints;
        private String mode;

        private HintsLevel(int numHint, String mode) {
            this.mode = mode;
            switch (numHint) {
                case 0: {
                    this.hints = new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                    this.hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE));
                    break;
                }
                case 1: {
                    this.hints = new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
                    this.hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT));
                    break;
                }
                case 2: {
                    this.hints = new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                    this.hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
                    this.hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                }
            }
        }

        public RenderingHints getRenderingHints() {
            return this.hints;
        }

        public String getModeName() {
            return this.mode;
        }

        public static HintsLevel getHintsForMode(String mode) {
            if (mode != null) {
                if (mode.equalsIgnoreCase(QUALITY.getModeName())) {
                    return QUALITY;
                }
                if (mode.equalsIgnoreCase(SPEED.getModeName())) {
                    return SPEED;
                }
                return DEFAULT;
            }
            return DEFAULT;
        }
    }

    static class PixelOffsets {
        int top;
        int bottom;
        int left;
        int right;

        PixelOffsets() {
        }
    }

    static class SpatialOffsets {
        double top;
        double bottom;
        double left;
        double right;

        SpatialOffsets() {
        }
    }
}

