/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io.codec;

import com.sun.media.imageioimpl.plugins.clib.CLibImageWriter;
import it.geosolutions.imageio.stream.output.ImageOutputStreamAdapter;
import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import it.geosolutions.jaiext.colorindexer.Quantizer;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.codec.ImageEncoder;
import org.geowebcache.io.codec.ImageIOInitializer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;

public class ImageEncoderImpl
implements ImageEncoder {
    private static final Logger LOGGER = Logging.getLogger((String)ImageEncoderImpl.class.getName());
    public static final String OPERATION_NOT_SUPPORTED = "Operation not supported";
    private final boolean isAggressiveOutputStreamSupported;
    private final List<String> supportedMimeTypes;
    private ImageWriterSpi spi;
    private Map<String, String> inputParams;
    private WriteHelper helper;

    @Override
    public void encode(RenderedImage image, Object destination, boolean aggressiveOutputStreamOptimization, MimeType type, Map<String, ?> map) throws Exception {
        block15: {
            if (!this.isAggressiveOutputStreamSupported() && aggressiveOutputStreamOptimization) {
                throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED);
            }
            ImageWriterSpi newSpi = this.getWriterSpi();
            if (newSpi != null) {
                ImageWriter writer = null;
                ImageInputStream stream = null;
                try {
                    writer = newSpi.createWriterInstance();
                    if (destination instanceof OutputStream) {
                        stream = this.isAggressiveOutputStreamSupported() ? new ImageOutputStreamAdapter((OutputStream)destination) : new MemoryCacheImageOutputStream((OutputStream)destination);
                        ImageWriteParam params = null;
                        RenderedImage finalImage = image;
                        if (this.helper != null) {
                            params = this.helper.prepareParams(this.inputParams, writer);
                            finalImage = this.helper.prepareImage(image, type);
                        }
                        writer.setOutput(stream);
                        writer.write(null, new IIOImage(finalImage, null, null), params);
                        break block15;
                    }
                    throw new IllegalArgumentException("Wrong output object");
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    throw e;
                }
                finally {
                    if (writer != null) {
                        writer.dispose();
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                        stream = null;
                    }
                }
            }
        }
    }

    ImageWriterSpi getWriterSpi() {
        return this.spi;
    }

    @Override
    public List<String> getSupportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    @Override
    public boolean isAggressiveOutputStreamSupported() {
        return this.isAggressiveOutputStreamSupported;
    }

    public ImageEncoderImpl(boolean aggressiveOutputStreamOptimization, List<String> supportedMimeTypes, List<String> writerSpi, Map<String, String> inputParams, ImageIOInitializer initializer) {
        this.isAggressiveOutputStreamSupported = aggressiveOutputStreamOptimization;
        this.supportedMimeTypes = new ArrayList<String>(supportedMimeTypes);
        this.inputParams = inputParams;
        IIORegistry theRegistry = initializer.getRegistry();
        for (String spi : writerSpi) {
            try {
                Class<?> clazz = Class.forName(spi);
                ImageWriterSpi writer = (ImageWriterSpi)theRegistry.getServiceProviderByClass(clazz);
                if (writer == null) continue;
                this.spi = writer;
                break;
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.helper = WriteHelper.getWriteHelperForName(supportedMimeTypes.get(0));
    }

    protected WriteHelper getHelper() {
        return this.helper;
    }

    private static RenderedImage applyPalette(RenderedImage canvas) {
        if (!(canvas.getColorModel() instanceof IndexColorModel)) {
            ImageWorker imageWorker = new ImageWorker(canvas);
            RenderedImage image = imageWorker.rescaleToBytes().forceComponentColorModel().getRenderedImage();
            ColorIndexer indexer = new Quantizer(256).subsample().buildColorIndexer(image);
            if (indexer != null) {
                image = new ImageWorker(image).colorIndex(indexer).getRenderedImage();
            }
            return image;
        }
        return canvas;
    }

    public static enum WriteHelper {
        PNG(new String[]{"image/png", "image/png8", "image/png; mode=8bit", "image/png24", "image/png; mode=24bit", "image/png;%20mode=24bit"}){

            @Override
            public ImageWriteParam prepareParameters(ImageWriter writer, String compression, boolean compressUsed, float compressionRate) {
                ImageWriteParam params = null;
                if (writer instanceof CLibImageWriter) {
                    params = writer.getDefaultWriteParam();
                    params.setCompressionMode(2);
                    if (compressUsed) {
                        params.setCompressionType(compression);
                    }
                    if (compressionRate > -1.0f) {
                        params.setCompressionQuality(compressionRate);
                    }
                } else if ("com.sun.imageio.plugins.png.PNGImageWriter".equals(writer.getClass().getName())) {
                    params = new ImageWorker.PNGImageWriteParam();
                    params.setCompressionMode(1);
                }
                return params;
            }

            @Override
            public RenderedImage prepareImage(RenderedImage image, MimeType type) {
                boolean isPNG8;
                boolean bl = isPNG8 = type == ImageMime.png8;
                if (isPNG8) {
                    return ImageEncoderImpl.applyPalette(image);
                }
                return image;
            }
        }
        ,
        JPEG(new String[]{"image/jpeg"}){

            @Override
            protected ImageWriteParam prepareParameters(ImageWriter writer, String compression, boolean compressUsed, float compressionRate) {
                ImageWriteParam params = writer.getDefaultWriteParam();
                params.setCompressionMode(2);
                if (compressUsed) {
                    params.setCompressionType(compression);
                }
                if (compressionRate > -1.0f) {
                    params.setCompressionQuality(compressionRate);
                }
                if (params instanceof JPEGImageWriteParam) {
                    JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)params;
                    jpegParams.setOptimizeHuffmanTables(true);
                    try {
                        jpegParams.setProgressiveMode(1);
                    }
                    catch (UnsupportedOperationException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    params = jpegParams;
                }
                return params;
            }
        }
        ,
        GIF(new String[]{"image/gif"}){

            @Override
            public RenderedImage prepareImage(RenderedImage image, MimeType type) {
                return ImageEncoderImpl.applyPalette(image);
            }
        }
        ,
        TIFF("image/tiff"),
        BMP("image/bmp");

        private String[] formatNames;

        private WriteHelper(String ... formatNames) {
            this.formatNames = formatNames;
        }

        public ImageWriteParam prepareParams(Map<String, String> inputParams, ImageWriter writer) {
            String compression = inputParams.get("COMPRESSION");
            boolean compressUsed = compression != null && !compression.isEmpty() && !compression.equalsIgnoreCase("null");
            String compressionRateValue = inputParams.get("COMPRESSION_RATE");
            float compressionRate = -1.0f;
            if (compressionRateValue != null) {
                try {
                    compressionRate = Float.parseFloat(compressionRateValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ImageWriteParam params = this.prepareParameters(writer, compression, compressUsed, compressionRate);
            return params;
        }

        protected ImageWriteParam prepareParameters(ImageWriter writer, String compression, boolean compressUsed, float compressionRate) {
            ImageWriteParam params = writer.getDefaultWriteParam();
            params.setCompressionMode(2);
            if (compressUsed) {
                params.setCompressionType(compression);
            }
            if (compressionRate > -1.0f) {
                params.setCompressionQuality(compressionRate);
            }
            return params;
        }

        public RenderedImage prepareImage(RenderedImage image, MimeType type) {
            return image;
        }

        private boolean isFormatNameAccepted(String formatName) {
            String format;
            boolean accepted = false;
            String[] stringArray = this.formatNames;
            int n = stringArray.length;
            for (int i = 0; i < n && !(accepted = (format = stringArray[i]).equalsIgnoreCase(formatName)); ++i) {
            }
            return accepted;
        }

        public static WriteHelper getWriteHelperForName(String formatName) {
            if (PNG.isFormatNameAccepted(formatName)) {
                return PNG;
            }
            if (JPEG.isFormatNameAccepted(formatName)) {
                return JPEG;
            }
            if (GIF.isFormatNameAccepted(formatName)) {
                return GIF;
            }
            if (TIFF.isFormatNameAccepted(formatName)) {
                return TIFF;
            }
            if (BMP.isFormatNameAccepted(formatName)) {
                return BMP;
            }
            return null;
        }
    }
}

