/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.zonal;

import com.sun.media.jai.util.PropertyUtil;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.zonal.ZoneGeometry;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.STRtree;

public class ZonalStatsOpImage
extends OpImage {
    protected static final BorderExtender ROI_EXTENDER = BorderExtender.createInstance((int)0);
    private static final Logger LOGGER = Logger.getLogger(ZonalStatsOpImage.class.getName());
    private AtomicBoolean firstTime = new AtomicBoolean(true);
    private final STRtree spatialIndex = new STRtree();
    private final boolean classPresent;
    private AffineTransform inverseTrans;
    private final boolean notHasNoData;
    private final Range noData;
    private final boolean[] booleanLookupTable;
    private Rectangle union;
    private Rectangle sourceBounds;
    private Rectangle classBounds;
    private RandomIter randomIterator;
    private int[] bands;
    private int bandNum;
    private List<ROI> rois;
    private boolean isNotIdentity;
    private final boolean updateIterator;
    private final RenderedImage classifier;
    private List<Range> rangeList;
    private final boolean ranges;
    private final boolean localStats;
    private Range rangeHelper;
    private final boolean rangesNoClass;
    private boolean hasROI;
    private boolean useROIAccessor;
    private boolean caseA;
    private boolean caseB;
    private boolean caseC;
    private PlanarImage srcROIImage;
    private ROI srcROI;
    private List<ZoneGeometry> zoneList;
    private RenderedOp srcROIImgExt;

    public ZonalStatsOpImage(RenderedImage source, ImageLayout layout, Map configuration, RenderedImage classifier, AffineTransform transform, List<ROI> rois, Range noData, ROI mask, boolean useROIAccessor, int[] bands, Statistics.StatsType[] statsTypes, double[] minBound, double[] maxBound, int[] numBins, List<Range> rangeData, boolean localStats) {
        super(ZonalStatsOpImage.vectorize((RenderedImage)source), layout, configuration, true);
        boolean bl = this.classPresent = classifier != null && classifier instanceof RenderedImage;
        if (this.classPresent) {
            int classDataType = classifier.getSampleModel().getDataType();
            if (classDataType != 0 && classDataType != 1 && classDataType != 2 && classDataType != 3) {
                throw new IllegalArgumentException("Classifier must be integral");
            }
            this.classifier = classifier;
        } else {
            this.classifier = null;
        }
        this.classBounds = null;
        this.isNotIdentity = false;
        if (this.classPresent) {
            this.sourceBounds = this.createBounds(source);
            if (transform == null) {
                this.inverseTrans = new AffineTransform();
                this.classBounds = this.sourceBounds;
            } else {
                try {
                    this.inverseTrans = transform.createInverse();
                    this.classBounds = this.inverseTrans.createTransformedShape(this.sourceBounds).getBounds();
                }
                catch (NoninvertibleTransformException ex) {
                    LOGGER.warning("The transformation matrix is non-invertible.");
                }
            }
            boolean bl2 = this.isNotIdentity = !this.inverseTrans.isIdentity();
            if (this.isNotIdentity) {
                this.randomIterator = RandomIterFactory.create((RenderedImage)classifier, (Rectangle)this.classBounds, (boolean)false, (boolean)true);
            }
            this.updateIterator = this.classPresent && !this.isNotIdentity;
        } else {
            this.updateIterator = false;
        }
        this.bands = bands;
        this.bandNum = bands.length;
        SampleModel sm = source.getSampleModel();
        int dataType = sm.getDataType();
        int numBands = sm.getNumBands();
        if (this.bandNum > numBands) {
            throw new IllegalArgumentException("The selected bands number cannot be greater than that of image band number");
        }
        if (this.bandNum <= 0) {
            this.bands = new int[]{0};
            this.bandNum = 1;
        } else {
            for (int i = 0; i < this.bandNum; ++i) {
                if (bands[i] <= numBands) continue;
                throw new IllegalArgumentException("Band index cannot be greater than the image band number");
            }
        }
        double[] minBounds = null;
        double[] maxBounds = null;
        int[] numBinss = null;
        boolean minBoundsNull = minBound == null;
        boolean maxBoundsNull = maxBound == null;
        boolean numBinsNull = numBins == null;
        boolean nullCondition = minBoundsNull || maxBoundsNull || numBinsNull;
        for (int st = 0; st < statsTypes.length; ++st) {
            int statId = statsTypes[st].getStatsId();
            if (statId <= 6 || !nullCondition) continue;
            throw new IllegalArgumentException("If complex statistics are used, Bounds and Bin number should be defined");
        }
        if (!nullCondition) {
            int minLen = minBound.length;
            int maxLen = maxBound.length;
            int numLen = numBins.length;
            if (minLen + maxLen + numLen != minLen * 3) {
                throw new IllegalArgumentException("Bounds and Bin length must be equals");
            }
            if (this.bandNum > minLen) {
                double[] minBoundsTmp = new double[bands.length];
                double[] maxBoundsTmp = new double[bands.length];
                int[] numbinsTmp = new int[bands.length];
                for (int i = 0; i < bands.length; ++i) {
                    minBoundsTmp[i] = minBound[0];
                    maxBoundsTmp[i] = maxBound[0];
                    numbinsTmp[i] = numBins[0];
                }
                minBounds = minBoundsTmp;
                maxBounds = maxBoundsTmp;
                numBinss = numbinsTmp;
            } else {
                minBounds = minBound;
                maxBounds = maxBound;
                numBinss = numBins;
            }
        }
        Range fullRange = RangeFactory.create((double)Double.NEGATIVE_INFINITY, (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)true, (boolean)false);
        ArrayList<Range> simpleRange = new ArrayList<Range>(1);
        simpleRange.add(fullRange);
        if (rangeData != null && !rangeData.isEmpty()) {
            for (Range r : rangeData) {
                Range.DataType type = r.getDataType();
                if (type.getDataType() == dataType) continue;
                throw new IllegalArgumentException("Wrong Range data type");
            }
            this.rangeList = Collections.unmodifiableList(rangeData);
            this.ranges = true;
            this.localStats = localStats;
            if (!localStats) {
                this.rangeHelper = fullRange;
            }
        } else {
            this.rangeHelper = fullRange;
            this.ranges = false;
            this.localStats = false;
        }
        boolean bl3 = this.rangesNoClass = this.ranges && !this.classPresent;
        if (rois == null || rois.isEmpty()) {
            this.zoneList = new ArrayList<ZoneGeometry>(1);
            this.rois = new ArrayList<ROI>();
            if (this.sourceBounds == null) {
                this.sourceBounds = this.createBounds(source);
            }
            ROIShape roi = new ROIShape((Shape)this.sourceBounds);
            this.rois.add((ROI)roi);
            this.union = new Rectangle(this.sourceBounds);
            Rectangle rect = roi.getBounds();
            double minX = rect.getMinX();
            double maxX = rect.getMaxX();
            double minY = rect.getMinY();
            double maxY = rect.getMaxY();
            Envelope env = new Envelope(minX, maxX, minY, maxY);
            ZoneGeometry geom = this.ranges && localStats ? new ZoneGeometry((ROI)roi, this.rangeList, bands, statsTypes, this.classPresent, minBounds, maxBounds, numBinss) : new ZoneGeometry((ROI)roi, simpleRange, bands, statsTypes, this.classPresent, minBounds, maxBounds, numBinss);
            this.spatialIndex.insert(env, (Object)geom);
            this.zoneList.add(geom);
        } else {
            this.union = new Rectangle(rois.get(0).getBounds());
            this.zoneList = new ArrayList<ZoneGeometry>(rois.size());
            for (ROI roi : rois) {
                Rectangle2D rect = roi.getBounds2D();
                double minX = Math.floor(rect.getMinX());
                double maxX = Math.ceil(rect.getMaxX());
                double minY = Math.floor(rect.getMinY());
                double maxY = Math.ceil(rect.getMaxY());
                Envelope env = new Envelope(minX, maxX, minY, maxY);
                Rectangle intRect = new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
                this.union = this.union.union(intRect);
                ZoneGeometry geom = this.ranges && localStats ? new ZoneGeometry(roi, this.rangeList, bands, statsTypes, this.classPresent, minBounds, maxBounds, numBinss) : new ZoneGeometry(roi, simpleRange, bands, statsTypes, this.classPresent, minBounds, maxBounds, numBinss);
                this.spatialIndex.insert(env, (Object)geom);
                this.zoneList.add(geom);
            }
            this.rois = rois;
        }
        Coordinate p1 = new Coordinate(0.0, 0.0);
        Envelope searchEnv = new Envelope(p1);
        this.spatialIndex.query(searchEnv);
        if (noData != null) {
            this.notHasNoData = false;
            this.noData = noData;
        } else {
            this.notHasNoData = true;
            this.noData = null;
        }
        if (!this.notHasNoData && source.getSampleModel().getDataType() == 0) {
            this.booleanLookupTable = new boolean[256];
            for (int i = 0; i < this.booleanLookupTable.length; ++i) {
                byte value = (byte)i;
                this.booleanLookupTable[i] = !noData.contains(value);
            }
        } else {
            this.booleanLookupTable = null;
        }
        if (mask != null) {
            this.hasROI = true;
            this.srcROI = mask;
            this.useROIAccessor = useROIAccessor;
            if (useROIAccessor) {
                this.srcROIImage = this.srcROI.getAsImage();
                Rectangle srcRect = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
                Rectangle roiBounds = this.srcROIImage.getBounds();
                int deltaX0 = roiBounds.x - srcRect.x;
                int leftP = deltaX0 > 0 ? deltaX0 : 0;
                int deltaY0 = roiBounds.y - srcRect.y;
                int topP = deltaY0 > 0 ? deltaY0 : 0;
                int deltaX1 = srcRect.x + srcRect.width - roiBounds.x + roiBounds.width;
                int rightP = deltaX1 > 0 ? deltaX1 : 0;
                int deltaY1 = srcRect.y + srcRect.height - roiBounds.y + roiBounds.height;
                int bottomP = deltaY1 > 0 ? deltaY1 : 0;
                ParameterBlock pb = new ParameterBlock();
                pb.setSource(this.srcROIImage, 0);
                pb.set(leftP, 0);
                pb.set(rightP, 1);
                pb.set(topP, 2);
                pb.set(bottomP, 3);
                pb.set(ROI_EXTENDER, 4);
                this.srcROIImgExt = JAI.create((String)"border", (ParameterBlock)pb);
            }
        } else {
            this.hasROI = false;
            this.useROIAccessor = false;
            this.srcROIImage = null;
        }
        this.caseA = this.notHasNoData && !this.hasROI;
        this.caseB = this.notHasNoData && this.hasROI;
        this.caseC = !this.notHasNoData && !this.hasROI;
    }

    private Rectangle createBounds(RenderedImage source) {
        return new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tileX, int tileY) {
        Raster tile = this.getSourceImage(0).getTile(tileX, tileY);
        Rectangle tileRect = tile.getBounds();
        boolean insideROIifPresent = true;
        ZonalStatsOpImage zonalStatsOpImage = this;
        synchronized (zonalStatsOpImage) {
            insideROIifPresent = this.hasROI && this.srcROI.intersects(tileRect) || !this.hasROI;
        }
        if (this.union.intersects(tileRect) && insideROIifPresent) {
            RasterFormatTag[] formatTags = this.getFormatTags();
            Rectangle computableArea = this.union.intersection(tileRect);
            RasterAccessor src = new RasterAccessor(tile, computableArea, formatTags[0], this.getSourceImage(0).getColorModel());
            RasterAccessor roi = null;
            if (this.useROIAccessor) {
                Raster roiRaster = null;
                roiRaster = this.srcROIImage.getBounds().contains(computableArea) ? this.srcROIImage.getData(computableArea) : this.srcROIImgExt.getData(computableArea);
                roi = new RasterAccessor(roiRaster, computableArea, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
            }
            int dataType = tile.getSampleModel().getDataType();
            switch (dataType) {
                case 0: {
                    this.byteLoop(src, computableArea, tileX, tileY, roi);
                    break;
                }
                case 1: {
                    this.ushortLoop(src, computableArea, tileX, tileY, roi);
                    break;
                }
                case 2: {
                    this.shortLoop(src, computableArea, tileX, tileY, roi);
                    break;
                }
                case 3: {
                    this.intLoop(src, computableArea, tileX, tileY, roi);
                    break;
                }
                case 4: {
                    this.floatLoop(src, computableArea, tileX, tileY, roi);
                    break;
                }
                case 5: {
                    this.doubleLoop(src, computableArea, tileX, tileY, roi);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void byteLoop(RasterAccessor src, Rectangle computableArea, int tileX, int tileY, RasterAccessor roi) {
        int roiDataLength;
        int roiScanLineStride;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        byte[][] srcData = src.getByteDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        RectIter rectIterator = null;
        if (this.updateIterator) {
            Raster ras = this.classifier.getTile(tileX, tileY);
            rectIterator = RectIterFactory.create((Raster)ras, (Rectangle)computableArea);
            rectIterator.startBands();
            rectIterator.startLines();
        }
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry zoneGeometry = zoneGeo;
                        synchronized (zoneGeometry) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block39: for (int i = 0; i < this.bandNum; ++i) {
                            byte value = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            int sample = value & 0xFF;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(value)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block39;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    int posYroi = y * roiScanLineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        int windex = x + posYroi;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry2 = zoneGeo.getROI();
                            boolean contains = false;
                            ZoneGeometry zoneGeometry = zoneGeo;
                            synchronized (zoneGeometry) {
                                contains = geometry2.contains(x0, y0);
                            }
                            if (!contains) continue;
                            block44: for (int i = 0; i < this.bandNum; ++i) {
                                int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                                if (this.rangesNoClass) {
                                    for (Range range : this.rangeList) {
                                        if (!range.contains((byte)sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block44;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            } else {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        boolean insideROI = false;
                        ZonalStatsOpImage windex = this;
                        synchronized (windex) {
                            insideROI = this.srcROI.contains(x0, y0);
                        }
                        if (!insideROI) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry = zoneGeo.getROI();
                            boolean contains2 = false;
                            ZoneGeometry geometry2 = zoneGeo;
                            synchronized (geometry2) {
                                contains2 = geometry.contains(x0, y0);
                            }
                            if (!contains2) continue;
                            block49: for (int i = 0; i < this.bandNum; ++i) {
                                int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                                if (this.rangesNoClass) {
                                    for (Range range : this.rangeList) {
                                        if (!range.contains((byte)sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block49;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry contains2 = zoneGeo;
                        synchronized (contains2) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block54: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                            if (!this.booleanLookupTable[sample]) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains((byte)sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block54;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                int posYroi = y * roiScanLineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    int windex = x + posYroi;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry3 = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry range = zoneGeo;
                        synchronized (range) {
                            contains = geometry3.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block59: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                            if (!this.booleanLookupTable[sample]) continue;
                            if (this.rangesNoClass) {
                                for (Range range2 : this.rangeList) {
                                    if (!range2.contains((byte)sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range2);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block59;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    boolean insideROI = false;
                    ZonalStatsOpImage windex = this;
                    synchronized (windex) {
                        insideROI = this.srcROI.contains(x0, y0);
                    }
                    if (!insideROI) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry geometry3 = zoneGeo;
                        synchronized (geometry3) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block64: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                            if (!this.booleanLookupTable[sample]) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains((byte)sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block64;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ushortLoop(RasterAccessor src, Rectangle computableArea, int tileX, int tileY, RasterAccessor roi) {
        int roiDataLength;
        int roiScanLineStride;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        short[][] srcData = src.getShortDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        RectIter rectIterator = null;
        if (this.updateIterator) {
            Raster ras = this.classifier.getTile(tileX, tileY);
            rectIterator = RectIterFactory.create((Raster)ras, (Rectangle)computableArea);
            rectIterator.startBands();
            rectIterator.startLines();
        }
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry zoneGeometry = zoneGeo;
                        synchronized (zoneGeometry) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block39: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains((short)sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block39;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    int posYroi = y * roiScanLineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        int windex = x + posYroi;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry2 = zoneGeo.getROI();
                            boolean contains = false;
                            ZoneGeometry range = zoneGeo;
                            synchronized (range) {
                                contains = geometry2.contains(x0, y0);
                            }
                            if (!contains) continue;
                            block44: for (int i = 0; i < this.bandNum; ++i) {
                                int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                                if (this.rangesNoClass) {
                                    for (Range range2 : this.rangeList) {
                                        if (!range2.contains((short)sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range2);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block44;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            } else {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        boolean insideROI = false;
                        ZonalStatsOpImage windex = this;
                        synchronized (windex) {
                            insideROI = this.srcROI.contains(x0, y0);
                        }
                        if (!insideROI) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry = zoneGeo.getROI();
                            boolean contains2 = false;
                            ZoneGeometry geometry2 = zoneGeo;
                            synchronized (geometry2) {
                                contains2 = geometry.contains(x0, y0);
                            }
                            if (!contains2) continue;
                            block49: for (int i = 0; i < this.bandNum; ++i) {
                                int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                                if (this.rangesNoClass) {
                                    for (Range range : this.rangeList) {
                                        if (!range.contains((short)sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block49;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry contains2 = zoneGeo;
                        synchronized (contains2) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block54: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                            if (this.noData.contains((short)sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains((short)sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block54;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                int posYroi = y * roiScanLineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    int windex = x + posYroi;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry3 = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry range = zoneGeo;
                        synchronized (range) {
                            contains = geometry3.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block59: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                            if (this.noData.contains((short)sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range3 : this.rangeList) {
                                    if (!range3.contains((short)sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range3);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block59;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    boolean insideROI = false;
                    ZonalStatsOpImage windex = this;
                    synchronized (windex) {
                        insideROI = this.srcROI.contains(x0, y0);
                    }
                    if (!insideROI) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry geometry3 = zoneGeo;
                        synchronized (geometry3) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block64: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                            if (this.noData.contains((short)sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains((short)sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block64;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shortLoop(RasterAccessor src, Rectangle computableArea, int tileX, int tileY, RasterAccessor roi) {
        int roiDataLength;
        int roiScanLineStride;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        short[][] srcData = src.getShortDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        RectIter rectIterator = null;
        if (this.updateIterator) {
            Raster ras = this.classifier.getTile(tileX, tileY);
            rectIterator = RectIterFactory.create((Raster)ras, (Rectangle)computableArea);
            rectIterator.startBands();
            rectIterator.startLines();
        }
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry zoneGeometry = zoneGeo;
                        synchronized (zoneGeometry) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block39: for (int i = 0; i < this.bandNum; ++i) {
                            short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block39;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    int posYroi = y * roiScanLineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        int windex = x + posYroi;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry2 = zoneGeo.getROI();
                            boolean contains = false;
                            ZoneGeometry range = zoneGeo;
                            synchronized (range) {
                                contains = geometry2.contains(x0, y0);
                            }
                            if (!contains) continue;
                            block44: for (int i = 0; i < this.bandNum; ++i) {
                                short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                                if (this.rangesNoClass) {
                                    for (Range range2 : this.rangeList) {
                                        if (!range2.contains(sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range2);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block44;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            } else {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        boolean insideROI = false;
                        ZonalStatsOpImage windex = this;
                        synchronized (windex) {
                            insideROI = this.srcROI.contains(x0, y0);
                        }
                        if (!insideROI) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry = zoneGeo.getROI();
                            boolean contains2 = false;
                            ZoneGeometry geometry2 = zoneGeo;
                            synchronized (geometry2) {
                                contains2 = geometry.contains(x0, y0);
                            }
                            if (!contains2) continue;
                            block49: for (int i = 0; i < this.bandNum; ++i) {
                                short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                                if (this.rangesNoClass) {
                                    for (Range range : this.rangeList) {
                                        if (!range.contains(sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block49;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry contains2 = zoneGeo;
                        synchronized (contains2) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block54: for (int i = 0; i < this.bandNum; ++i) {
                            short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block54;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                int posYroi = y * roiScanLineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    int windex = x + posYroi;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry3 = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry range = zoneGeo;
                        synchronized (range) {
                            contains = geometry3.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block59: for (int i = 0; i < this.bandNum; ++i) {
                            short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range3 : this.rangeList) {
                                    if (!range3.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range3);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block59;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    boolean insideROI = false;
                    ZonalStatsOpImage windex = this;
                    synchronized (windex) {
                        insideROI = this.srcROI.contains(x0, y0);
                    }
                    if (!insideROI) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry geometry3 = zoneGeo;
                        synchronized (geometry3) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block64: for (int i = 0; i < this.bandNum; ++i) {
                            short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block64;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intLoop(RasterAccessor src, Rectangle computableArea, int tileX, int tileY, RasterAccessor roi) {
        int roiDataLength;
        int roiScanLineStride;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        int[][] srcData = src.getIntDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        RectIter rectIterator = null;
        if (this.updateIterator) {
            Raster ras = this.classifier.getTile(tileX, tileY);
            rectIterator = RectIterFactory.create((Raster)ras, (Rectangle)computableArea);
            rectIterator.startBands();
            rectIterator.startLines();
        }
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry zoneGeometry = zoneGeo;
                        synchronized (zoneGeometry) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block39: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block39;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    int posYroi = y * roiScanLineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        int windex = x + posYroi;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry2 = zoneGeo.getROI();
                            boolean contains = false;
                            ZoneGeometry range = zoneGeo;
                            synchronized (range) {
                                contains = geometry2.contains(x0, y0);
                            }
                            if (!contains) continue;
                            block44: for (int i = 0; i < this.bandNum; ++i) {
                                int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                                if (this.rangesNoClass) {
                                    for (Range range2 : this.rangeList) {
                                        if (!range2.contains(sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range2);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block44;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            } else {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        boolean insideROI = false;
                        ZonalStatsOpImage windex = this;
                        synchronized (windex) {
                            insideROI = this.srcROI.contains(x0, y0);
                        }
                        if (!insideROI) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry = zoneGeo.getROI();
                            boolean contains2 = false;
                            ZoneGeometry geometry2 = zoneGeo;
                            synchronized (geometry2) {
                                contains2 = geometry.contains(x0, y0);
                            }
                            if (!contains2) continue;
                            block49: for (int i = 0; i < this.bandNum; ++i) {
                                int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                                if (this.rangesNoClass) {
                                    for (Range range : this.rangeList) {
                                        if (!range.contains(sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block49;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry contains2 = zoneGeo;
                        synchronized (contains2) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block54: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block54;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                int posYroi = y * roiScanLineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    int windex = x + posYroi;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry3 = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry range = zoneGeo;
                        synchronized (range) {
                            contains = geometry3.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block59: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range3 : this.rangeList) {
                                    if (!range3.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range3);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block59;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    boolean insideROI = false;
                    ZonalStatsOpImage windex = this;
                    synchronized (windex) {
                        insideROI = this.srcROI.contains(x0, y0);
                    }
                    if (!insideROI) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry geometry3 = zoneGeo;
                        synchronized (geometry3) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block64: for (int i = 0; i < this.bandNum; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block64;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void floatLoop(RasterAccessor src, Rectangle computableArea, int tileX, int tileY, RasterAccessor roi) {
        int roiDataLength;
        int roiScanLineStride;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        float[][] srcData = src.getFloatDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        RectIter rectIterator = null;
        if (this.updateIterator) {
            Raster ras = this.classifier.getTile(tileX, tileY);
            rectIterator = RectIterFactory.create((Raster)ras, (Rectangle)computableArea);
            rectIterator.startBands();
            rectIterator.startLines();
        }
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry zoneGeometry = zoneGeo;
                        synchronized (zoneGeometry) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block39: for (int i = 0; i < this.bandNum; ++i) {
                            float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block39;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    int posYroi = y * roiScanLineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        int windex = x + posYroi;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry2 = zoneGeo.getROI();
                            boolean contains = false;
                            ZoneGeometry range = zoneGeo;
                            synchronized (range) {
                                contains = geometry2.contains(x0, y0);
                            }
                            if (!contains) continue;
                            block44: for (int i = 0; i < this.bandNum; ++i) {
                                float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                                if (this.rangesNoClass) {
                                    for (Range range2 : this.rangeList) {
                                        if (!range2.contains(sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range2);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block44;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            } else {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        boolean insideROI = false;
                        ZonalStatsOpImage windex = this;
                        synchronized (windex) {
                            insideROI = this.srcROI.contains(x0, y0);
                        }
                        if (!insideROI) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry = zoneGeo.getROI();
                            boolean contains2 = false;
                            ZoneGeometry geometry2 = zoneGeo;
                            synchronized (geometry2) {
                                contains2 = geometry.contains(x0, y0);
                            }
                            if (!contains2) continue;
                            block49: for (int i = 0; i < this.bandNum; ++i) {
                                float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                                if (this.rangesNoClass) {
                                    for (Range range : this.rangeList) {
                                        if (!range.contains(sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block49;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry contains2 = zoneGeo;
                        synchronized (contains2) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block54: for (int i = 0; i < this.bandNum; ++i) {
                            float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block54;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                int posYroi = y * roiScanLineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    int windex = x + posYroi;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry3 = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry range = zoneGeo;
                        synchronized (range) {
                            contains = geometry3.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block59: for (int i = 0; i < this.bandNum; ++i) {
                            float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range3 : this.rangeList) {
                                    if (!range3.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range3);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block59;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    boolean insideROI = false;
                    ZonalStatsOpImage windex = this;
                    synchronized (windex) {
                        insideROI = this.srcROI.contains(x0, y0);
                    }
                    if (!insideROI) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry geometry3 = zoneGeo;
                        synchronized (geometry3) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block64: for (int i = 0; i < this.bandNum; ++i) {
                            float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block64;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doubleLoop(RasterAccessor src, Rectangle computableArea, int tileX, int tileY, RasterAccessor roi) {
        int roiDataLength;
        int roiScanLineStride;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        double[][] srcData = src.getDoubleDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        RectIter rectIterator = null;
        if (this.updateIterator) {
            Raster ras = this.classifier.getTile(tileX, tileY);
            rectIterator = RectIterFactory.create((Raster)ras, (Rectangle)computableArea);
            rectIterator.startBands();
            rectIterator.startLines();
        }
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineStride = roi.getScanlineStride();
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineStride = 0;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry zoneGeometry = zoneGeo;
                        synchronized (zoneGeometry) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block39: for (int i = 0; i < this.bandNum; ++i) {
                            double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block39;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    int posYroi = y * roiScanLineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        int windex = x + posYroi;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry2 = zoneGeo.getROI();
                            boolean contains = false;
                            ZoneGeometry zoneGeometry = zoneGeo;
                            synchronized (zoneGeometry) {
                                contains = geometry2.contains(x0, y0);
                            }
                            if (!contains) continue;
                            block44: for (int i = 0; i < this.bandNum; ++i) {
                                double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                                if (this.rangesNoClass) {
                                    for (Range range : this.rangeList) {
                                        if (!range.contains(sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block44;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            } else {
                for (int y = 0; y < srcHeight; ++y) {
                    if (this.updateIterator) {
                        rectIterator.startPixels();
                    }
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; ++x) {
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.union.contains(x0, y0)) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        boolean insideROI = false;
                        ZonalStatsOpImage windex = this;
                        synchronized (windex) {
                            insideROI = this.srcROI.contains(x0, y0);
                        }
                        if (!insideROI) {
                            if (!this.updateIterator) continue;
                            rectIterator.nextPixel();
                            continue;
                        }
                        Coordinate p1 = new Coordinate((double)x0, (double)y0);
                        Envelope searchEnv = new Envelope(p1);
                        List geomList = this.spatialIndex.query(searchEnv);
                        int classId = 0;
                        if (this.classPresent) {
                            Point pointSrc = new Point(x0, y0);
                            Point pointClass = new Point();
                            try {
                                if (this.isNotIdentity) {
                                    this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                    classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                                } else {
                                    classId = rectIterator.getSample();
                                    rectIterator.nextPixel();
                                }
                            }
                            catch (NoninvertibleTransformException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        for (ZoneGeometry zoneGeo : geomList) {
                            ROI geometry = zoneGeo.getROI();
                            boolean contains2 = false;
                            ZoneGeometry geometry2 = zoneGeo;
                            synchronized (geometry2) {
                                contains2 = geometry.contains(x0, y0);
                            }
                            if (!contains2) continue;
                            block49: for (int i = 0; i < this.bandNum; ++i) {
                                double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                                if (this.rangesNoClass) {
                                    for (Range range : this.rangeList) {
                                        if (!range.contains(sample)) continue;
                                        if (this.localStats) {
                                            zoneGeo.add(sample, this.bands[i], classId, range);
                                            continue;
                                        }
                                        zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                        continue block49;
                                    }
                                    continue;
                                }
                                zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                            }
                        }
                    }
                    if (!this.updateIterator) continue;
                    rectIterator.nextLine();
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry contains2 = zoneGeo;
                        synchronized (contains2) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block54: for (int i = 0; i < this.bandNum; ++i) {
                            double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block54;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                int posYroi = y * roiScanLineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    int windex = x + posYroi;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry3 = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry i = zoneGeo;
                        synchronized (i) {
                            contains = geometry3.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block59: for (int i2 = 0; i2 < this.bandNum; ++i2) {
                            double sample = srcData[this.bands[i2]][posx + posy + srcBandOffsets[this.bands[i2]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i2], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i2], classId, this.rangeHelper);
                                    continue block59;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i2], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        } else {
            for (int y = 0; y < srcHeight; ++y) {
                if (this.updateIterator) {
                    rectIterator.startPixels();
                }
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; ++x) {
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.union.contains(x0, y0)) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    boolean insideROI = false;
                    ZonalStatsOpImage windex = this;
                    synchronized (windex) {
                        insideROI = this.srcROI.contains(x0, y0);
                    }
                    if (!insideROI) {
                        if (!this.updateIterator) continue;
                        rectIterator.nextPixel();
                        continue;
                    }
                    Coordinate p1 = new Coordinate((double)x0, (double)y0);
                    Envelope searchEnv = new Envelope(p1);
                    List geomList = this.spatialIndex.query(searchEnv);
                    int classId = 0;
                    if (this.classPresent) {
                        Point pointSrc = new Point(x0, y0);
                        Point pointClass = new Point();
                        try {
                            if (this.isNotIdentity) {
                                this.inverseTrans.inverseTransform(pointSrc, pointClass);
                                classId = this.randomIterator.getSample(pointClass.x, pointClass.y, 0);
                            } else {
                                classId = rectIterator.getSample();
                                rectIterator.nextPixel();
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    for (ZoneGeometry zoneGeo : geomList) {
                        ROI geometry = zoneGeo.getROI();
                        boolean contains = false;
                        ZoneGeometry geometry3 = zoneGeo;
                        synchronized (geometry3) {
                            contains = geometry.contains(x0, y0);
                        }
                        if (!contains) continue;
                        block64: for (int i = 0; i < this.bandNum; ++i) {
                            double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            if (this.noData.contains(sample)) continue;
                            if (this.rangesNoClass) {
                                for (Range range : this.rangeList) {
                                    if (!range.contains(sample)) continue;
                                    if (this.localStats) {
                                        zoneGeo.add(sample, this.bands[i], classId, range);
                                        continue;
                                    }
                                    zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                                    continue block64;
                                }
                                continue;
                            }
                            zoneGeo.add(sample, this.bands[i], classId, this.rangeHelper);
                        }
                    }
                }
                if (!this.updateIterator) continue;
                rectIterator.nextLine();
            }
        }
    }

    public Rectangle mapDestRect(Rectangle destRect, int index) {
        return destRect;
    }

    public Rectangle mapSourceRect(Rectangle sourceRect, int index) {
        return sourceRect;
    }

    public String[] getPropertyNames() {
        String[] statsNames = new String[]{"JAI-EXT.zonalstats"};
        String[] superNames = super.getPropertyNames();
        if (superNames == null) {
            return statsNames;
        }
        ArrayList<String> extraNames = new ArrayList<String>();
        for (int i = 0; i < statsNames.length; ++i) {
            String prefix = statsNames[i];
            String[] names = PropertyUtil.getPropertyNames((String[])superNames, (String)prefix);
            if (names == null) continue;
            for (int j = 0; j < names.length; ++j) {
                if (!names[j].equalsIgnoreCase(prefix)) continue;
                extraNames.add(prefix);
            }
        }
        if (extraNames.size() == 0) {
            return superNames;
        }
        String[] propNames = new String[superNames.length + extraNames.size()];
        System.arraycopy(superNames, 0, propNames, 0, superNames.length);
        int offset = superNames.length;
        for (int i = 0; i < extraNames.size(); ++i) {
            propNames[offset++] = (String)extraNames.get(i);
        }
        return propNames;
    }

    public synchronized void clearStatistic() {
        this.firstTime.set(true);
    }

    public Raster[] getTiles() {
        if (this.firstTime.getAndSet(false)) {
            Point[] points = this.getTileIndices(this.union);
            if (points != null) {
                return this.getTiles(points);
            }
            return null;
        }
        return null;
    }

    public Object getProperty(String name) {
        if ("JAI-EXT.zonalstats".equalsIgnoreCase(name)) {
            Point[] tileIndices;
            for (Point tileIndex : tileIndices = this.getTileIndices(this.union)) {
                this.getTile(tileIndex.x, tileIndex.y);
            }
            return Collections.unmodifiableList(this.zoneList);
        }
        return super.getProperty(name);
    }

    public synchronized void dispose() {
        if (this.srcROIImgExt != null) {
            this.srcROIImgExt.dispose();
        }
        super.dispose();
    }
}

