/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PngChunkZTXT
extends PngChunkTextVar {
    public static final String ID = "zTXt";

    public PngChunkZTXT(ImageInfo info) {
        super(ID, info);
    }

    public ChunkRaw createRawChunk() {
        if (this.key == null || this.key.trim().length() == 0) {
            throw new PngjException("Text chunk key must be non empty");
        }
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ba.write(ChunkHelper.toBytes(this.key));
            ba.write(0);
            ba.write(0);
            byte[] textbytes = ChunkHelper.compressBytes(ChunkHelper.toBytes(this.val), true);
            ba.write(textbytes);
            byte[] b = ba.toByteArray();
            ChunkRaw chunk = this.createEmptyChunk(b.length, false);
            chunk.data = b;
            return chunk;
        }
        catch (IOException e) {
            throw new PngjException(e);
        }
    }

    public void parseFromRaw(ChunkRaw c) {
        int nullsep = -1;
        for (int i = 0; i < c.data.length; ++i) {
            if (c.data[i] != 0) continue;
            nullsep = i;
            break;
        }
        if (nullsep < 0 || nullsep > c.data.length - 2) {
            throw new PngjException("bad zTXt chunk: no separator found");
        }
        this.key = ChunkHelper.toString(c.data, 0, nullsep);
        byte compmet = c.data[nullsep + 1];
        if (compmet != 0) {
            throw new PngjException("bad zTXt chunk: unknown compression method");
        }
        byte[] uncomp = ChunkHelper.compressBytes(c.data, nullsep + 2, c.data.length - nullsep - 2, false);
        this.val = ChunkHelper.toString(uncomp);
    }

    public PngChunk cloneForWrite(ImageInfo imgInfo) {
        PngChunkZTXT other = new PngChunkZTXT(imgInfo);
        other.key = this.key;
        other.val = this.val;
        return other;
    }
}

