/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.rest.controller;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.diskquota.ConfigLoader;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.storage.blobstore.memory.CacheStatistics;
import org.geowebcache.util.ApplicationContextProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}/rest"})
public class DiskQuotaController {
    private final WebApplicationContext context;
    static final Logger LOG = Logging.getLogger((String)DiskQuotaController.class.getName());
    @Autowired
    DiskQuotaMonitor monitor;

    @Autowired
    public DiskQuotaController(ApplicationContextProvider appCtx) {
        this.context = appCtx == null ? null : appCtx.getApplicationContext();
    }

    public void setDiskQuotaMonitor(DiskQuotaMonitor monitor) {
        this.monitor = monitor;
    }

    @RequestMapping(value={"/diskquota"}, method={RequestMethod.GET})
    public ResponseEntity<?> doGet(HttpServletRequest request) {
        DiskQuotaConfig config = this.monitor.getConfig();
        if (request.getPathInfo().contains("json")) {
            try {
                return this.getJsonRepresentation(config);
            }
            catch (JSONException e) {
                return new ResponseEntity((Object)"Caught JSON Execption.", HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return this.getXmlRepresentation(config);
    }

    @RequestMapping(value={"/diskquota"}, method={RequestMethod.PUT})
    public ResponseEntity<?> doPut(HttpServletRequest request) {
        DiskQuotaConfig config = this.monitor.getConfig();
        DiskQuotaConfig newConfig = null;
        String reqData = "";
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)request.getInputStream(), (Writer)writer, (Charset)Charset.defaultCharset());
            reqData = writer.toString();
            if (request.getPathInfo().contains("json")) {
                newConfig = this.fromJSON(reqData);
                this.applyDiff(config, newConfig);
                return this.getJsonRepresentation(config);
            }
            newConfig = this.fromXML(reqData);
            this.applyDiff(config, newConfig);
            return this.getXmlRepresentation(config);
        }
        catch (IOException | JSONException e) {
            return new ResponseEntity((Object)"Error writing input stream to string", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void applyDiff(DiskQuotaConfig config, DiskQuotaConfig newConfig) throws IllegalArgumentException {
        if (newConfig != null) {
            if (null != newConfig.isEnabled()) {
                config.setEnabled(newConfig.isEnabled());
            }
            if (null != newConfig.getCacheCleanUpFrequency()) {
                config.setCacheCleanUpFrequency(newConfig.getCacheCleanUpFrequency());
            }
            if (null != newConfig.getMaxConcurrentCleanUps()) {
                config.setMaxConcurrentCleanUps(newConfig.getMaxConcurrentCleanUps());
            }
            if (null != newConfig.getCacheCleanUpUnits()) {
                config.setCacheCleanUpUnits(newConfig.getCacheCleanUpUnits());
            }
            if (null != newConfig.getGlobalExpirationPolicyName()) {
                config.setGlobalExpirationPolicyName(newConfig.getGlobalExpirationPolicyName());
            }
            if (null != newConfig.getGlobalQuota()) {
                config.setGlobalQuota(newConfig.getGlobalQuota());
            }
            if (null != newConfig.getLayerQuotas()) {
                config.setLayerQuotas(newConfig.getLayerQuotas());
            }
        }
    }

    private DiskQuotaConfig fromJSON(String entity) throws IOException {
        String text = entity;
        JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
        GeoWebCacheXStream xStream = new GeoWebCacheXStream((HierarchicalStreamDriver)driver);
        xStream = ConfigLoader.getConfiguredXStream((XStream)xStream);
        try (StringReader reader = new StringReader(text);){
            DiskQuotaConfig configuration;
            DiskQuotaConfig diskQuotaConfig = configuration = ConfigLoader.loadConfiguration(reader, (XStream)xStream);
            return diskQuotaConfig;
        }
    }

    private DiskQuotaConfig fromXML(String entity) throws IOException {
        String text = entity;
        try (StringReader reader = new StringReader(text);){
            DiskQuotaConfig diskQuotaConfig;
            XStream xstream = ConfigLoader.getConfiguredXStream((XStream)new GeoWebCacheXStream());
            DiskQuotaConfig diskQuotaConfig2 = diskQuotaConfig = ConfigLoader.loadConfiguration(reader, xstream);
            return diskQuotaConfig2;
        }
    }

    private ResponseEntity<?> getJsonRepresentation(DiskQuotaConfig config) throws JSONException {
        XStream xs = XMLConfiguration.getConfiguredXStreamWithContext((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()), (WebApplicationContext)this.context, (ContextualConfigurationProvider.Context)ContextualConfigurationProvider.Context.REST);
        JSONObject obj = new JSONObject(xs.toXML((Object)config));
        return new ResponseEntity((Object)obj.toString(), HttpStatus.OK);
    }

    private ResponseEntity<?> getXmlRepresentation(DiskQuotaConfig config) {
        XStream xStream = DiskQuotaController.getConfiguredXStream((XStream)new GeoWebCacheXStream());
        String xmlText = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xStream.toXML((Object)config);
        return new ResponseEntity((Object)xmlText, HttpStatus.OK);
    }

    public static XStream getConfiguredXStream(XStream xs) {
        xs.setMode(1001);
        xs.alias("gwcInMemoryCacheStatistics", CacheStatistics.class);
        return xs;
    }
}

