/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.locationtech.jts.geom.Geometry;

@DescribeProcess(title="Transform", description="Computes a new feature collection from the input one by renaming, deleting, and computing new attributes.  Attribute values are specified as ECQL expressions in the form name=expression.")
public class TransformProcess
implements VectorProcess {
    @DescribeResult(name="result", description="Transformed feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="transform", description="The transform specification, as a list of specifiers of the form name=expression, delimited by newlines or semicolons.") String transform) throws ProcessException {
        if (transform == null) {
            return features;
        }
        List<Definition> list = TransformProcess.toDefinition(transform);
        return this.executeList(features, list);
    }

    @DescribeResult(name="result", description="Transformed feature collection")
    public SimpleFeatureCollection executeList(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="transform", description="List of Definitions for the output feature attributes") List<Definition> transform) throws ProcessException {
        if (transform == null) {
            return features;
        }
        return new ReshapeFeatureCollection(features, transform);
    }

    public static List<Definition> toDefinition(String definition) {
        String[] defs;
        ArrayList<Definition> list = new ArrayList<Definition>();
        HashSet<String> check = new HashSet<String>();
        for (String line : defs = TransformProcess.splitDefinitions(definition)) {
            Expression expression;
            int mark = line.indexOf("=");
            if (mark == -1) continue;
            String name = line.substring(0, mark).trim();
            String expressionDefinition = line.substring(mark + 1).trim();
            if (check.contains(name)) {
                throw new IllegalArgumentException("Attribute " + name + " defined more than once");
            }
            try {
                expression = ECQL.toExpression((String)expressionDefinition);
            }
            catch (CQLException e) {
                throw new IllegalArgumentException("Unable to parse expression " + name + "=" + expressionDefinition + " " + e, e);
            }
            Definition def = new Definition();
            def.name = name;
            def.expression = expression;
            list.add(def);
            check.add(name);
        }
        return list;
    }

    private static String[] splitDefinitions(String defList) {
        String defListLF = defList.replaceAll(";", "\n");
        return defListLF.split("\n");
    }

    public static SimpleFeatureType toReShapeFeatureType(SimpleFeatureCollection delegate, List<Definition> definitionList) {
        SimpleFeature sample = null;
        try (SimpleFeatureIterator iterator = delegate.features();){
            if (iterator.hasNext()) {
                sample = (SimpleFeature)iterator.next();
            }
        }
        SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
        SimpleFeatureType origional = (SimpleFeatureType)delegate.getSchema();
        for (Definition def : definitionList) {
            String name = def.name;
            Expression expression = def.expression;
            Object value = null;
            if (sample != null) {
                value = expression.evaluate((Object)sample);
            }
            Class binding = def.binding;
            if (value == null) {
                if (expression instanceof PropertyName) {
                    AttributeDescriptor descriptor = origional.getDescriptor(name);
                    AttributeType attributeType = descriptor.getType();
                    binding = attributeType.getBinding();
                }
            } else {
                binding = value.getClass();
            }
            if (binding == null) {
                throw new IllegalArgumentException("Unable to determine type for " + name);
            }
            if (Geometry.class.isAssignableFrom(binding)) {
                CoordinateReferenceSystem crs;
                AttributeType originalAttributeType = origional.getType(name);
                if (originalAttributeType != null && originalAttributeType instanceof GeometryType) {
                    GeometryType geometryType = (GeometryType)originalAttributeType;
                    crs = geometryType.getCoordinateReferenceSystem();
                } else {
                    crs = origional.getCoordinateReferenceSystem();
                }
                build.crs(crs);
                build.add(name, binding);
                continue;
            }
            build.add(name, binding);
        }
        build.setName(origional.getTypeName());
        return build.buildFeatureType();
    }

    static class ReshapeFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator delegate;
        List<Definition> definition;
        SimpleFeatureBuilder fb;

        public ReshapeFeatureIterator(SimpleFeatureIterator delegate, List<Definition> definition, SimpleFeatureType schema) {
            this.delegate = delegate;
            this.definition = definition;
            this.fb = new SimpleFeatureBuilder(schema);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature feature = (SimpleFeature)this.delegate.next();
            for (Definition def : this.definition) {
                Object value = def.expression.evaluate((Object)feature);
                this.fb.add(value);
            }
            SimpleFeature created = this.fb.buildFeature(feature.getID());
            return created;
        }
    }

    static class ReshapeFeatureCollection
    extends DecoratingSimpleFeatureCollection {
        List<Definition> definition;
        SimpleFeatureType schema;

        public ReshapeFeatureCollection(SimpleFeatureCollection delegate, List<Definition> definition) {
            super(delegate);
            this.definition = definition;
            this.schema = TransformProcess.toReShapeFeatureType(delegate, definition);
        }

        @Override
        public SimpleFeatureType getSchema() {
            return this.schema;
        }

        @Override
        public SimpleFeatureIterator features() {
            return new ReshapeFeatureIterator(this.delegate.features(), this.definition, this.schema);
        }
    }

    public static class Definition {
        public String name;
        public Expression expression;
        public Class<?> binding;
    }
}

