/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.time;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.time.TimestampFileNameExtractor;
import org.geotools.util.URLs;

public class TimestampFileNameExtractorSPI
implements PropertiesCollectorSPI {
    public static final String REGEX = "regex";
    public static final String FORMAT = "format";
    public static final String FULL_PATH = "fullPath";
    public static final String USE_HIGH_TIME = "useHighTime";
    public static final String REGEX_PREFIX = "regex=";
    public static final String FORMAT_PREFIX = "format=";
    public static final String FULL_PATH_PREFIX = "fullPath=";
    public static final String USE_HIGH_TIME_PREFIX = "useHighTime=";

    @Override
    public String getName() {
        return "TimestampFileNameExtractorSPI";
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PropertiesCollector create(Object o, List<String> propertyNames) {
        Properties properties;
        boolean fullPath;
        boolean useHighTime;
        String format;
        String regex;
        URL source;
        block14: {
            source = null;
            regex = null;
            format = null;
            useHighTime = false;
            fullPath = false;
            properties = null;
            if (o instanceof URL) {
                source = (URL)o;
            } else if (o instanceof File) {
                source = URLs.fileToUrl((File)((File)o));
            } else {
                if (!(o instanceof String)) return null;
                try {
                    source = new URL((String)o);
                }
                catch (MalformedURLException e) {
                    String value = (String)o;
                    int minIndex = value.length();
                    int[] indexesOf = new int[]{value.indexOf(",format="), value.indexOf(",fullPath="), value.indexOf(",useHighTime=")};
                    for (int indexOf : indexesOf) {
                        minIndex = indexOf > 0 && indexOf < minIndex ? indexOf : minIndex;
                    }
                    if (!value.startsWith(REGEX_PREFIX)) break block14;
                    String prop = value;
                    regex = value.substring(REGEX_PREFIX.length(), minIndex);
                    if (minIndex == value.length()) break block14;
                    value = value.substring(minIndex + 1);
                    prop = value.replaceAll(",", "\n");
                    properties = new Properties();
                    try {
                        properties.load(new StringReader(prop));
                        properties.setProperty(REGEX, regex);
                    }
                    catch (IOException e1) {
                        throw new IllegalArgumentException("Unable to parse the specified regex: " + value, e1);
                    }
                }
            }
        }
        if (source != null) {
            properties = CoverageUtilities.loadPropertiesFromURL((URL)source);
        }
        if (properties != null) {
            String useHighTimeParam;
            regex = properties.getProperty(REGEX);
            format = properties.getProperty(FORMAT);
            String fullPathParam = properties.getProperty(FULL_PATH);
            if (fullPathParam != null && fullPathParam.trim().length() > 0) {
                fullPath = Boolean.valueOf(fullPathParam);
            }
            if ((useHighTimeParam = properties.getProperty(USE_HIGH_TIME)) != null && useHighTimeParam.trim().length() > 0) {
                useHighTime = Boolean.valueOf(useHighTimeParam);
            }
        }
        if (format != null) {
            format = format.trim();
        }
        if (regex == null) return null;
        regex = regex.trim();
        return new TimestampFileNameExtractor(this, propertyNames, regex, format, fullPath, useHighTime);
    }
}

