/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.properties.FullPathCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.util.URLs;

public abstract class DefaultPropertiesCollectorSPI
implements PropertiesCollectorSPI {
    private final String name;
    public static final String REGEX = "regex";
    public static final String FULL_PATH = "fullPath";
    public static final String REGEX_PREFIX = "regex=";
    public static final String FULL_PATH_PREFIX = "fullPath=";

    @Override
    public String getName() {
        return this.name;
    }

    public DefaultPropertiesCollectorSPI(String name) {
        this.name = name;
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PropertiesCollector create(Object o, List<String> propertyNames) {
        Properties properties;
        String regex;
        URL source;
        block15: {
            source = null;
            regex = null;
            properties = null;
            if (o instanceof URL) {
                source = (URL)o;
            } else if (o instanceof File) {
                source = URLs.fileToUrl((File)((File)o));
            } else {
                if (!(o instanceof String)) return null;
                try {
                    source = new URL((String)o);
                }
                catch (MalformedURLException e) {
                    String value = (String)o;
                    int[] indexesOf = new int[3];
                    indexesOf[1] = value.indexOf(",fullPath=");
                    int minIndex = value.length();
                    for (int indexOf : indexesOf) {
                        minIndex = indexOf > 0 && indexOf < minIndex ? indexOf : minIndex;
                    }
                    if (!value.startsWith(REGEX_PREFIX)) break block15;
                    String prop = value;
                    regex = value.substring(REGEX_PREFIX.length(), minIndex);
                    if (minIndex == value.length()) break block15;
                    value = value.substring(minIndex + 1);
                    prop = value.replaceAll(",", "\n");
                    properties = new Properties();
                    try {
                        properties.load(new StringReader(prop));
                        properties.setProperty(REGEX, regex);
                    }
                    catch (IOException e1) {
                        throw new IllegalArgumentException("Unable to parse the specified regex: " + value, e1);
                    }
                }
            }
        }
        boolean fullPath = false;
        if (source != null) {
            properties = CoverageUtilities.loadPropertiesFromURL((URL)source);
            if (properties.containsKey(REGEX)) {
                regex = properties.getProperty(REGEX);
                fullPath = Boolean.valueOf(properties.getProperty(FULL_PATH));
            }
        } else if (properties != null) {
            regex = properties.getProperty(REGEX);
            String fullPathParam = properties.getProperty(FULL_PATH);
            if (fullPathParam != null && fullPathParam.trim().length() > 0) {
                fullPath = Boolean.valueOf(fullPathParam);
            }
        }
        if (regex == null) return null;
        PropertiesCollector pc = this.createInternal(this, propertyNames, regex.trim());
        if (pc == null) {
            return null;
        }
        if (!fullPath) return pc;
        if (!(pc instanceof FullPathCollector)) throw new IllegalArgumentException("This collector does not support the full path option: " + pc.getSpi());
        ((FullPathCollector)((Object)pc)).setFullPath(true);
        return pc;
    }

    protected abstract PropertiesCollector createInternal(PropertiesCollectorSPI var1, List<String> var2, String var3);
}

