/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.properties.CRSExtractorSPI;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.referencing.CRS;

public class CRSExtractor
extends PropertiesCollector {
    public static final String DEFAULT_ATTRIBUTE_NAME = "crs";
    private String crsCode;

    public CRSExtractor() {
        this(new CRSExtractorSPI(), Collections.singletonList(DEFAULT_ATTRIBUTE_NAME));
    }

    public CRSExtractor(PropertiesCollectorSPI spi, List<String> propertyNames) {
        super(spi, propertyNames);
    }

    @Override
    public void setProperties(SimpleFeature feature) {
        feature.setAttribute(this.getPropertyNames().get(0), (Object)this.crsCode);
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        this.getPropertyNames().forEach(propName -> map.put((String)propName, this.crsCode));
    }

    @Override
    public PropertiesCollector collect(GridCoverage2DReader gridCoverageReader) {
        CoordinateReferenceSystem crs = gridCoverageReader.getCoordinateReferenceSystem();
        this.crsCode = CRS.toSRS((CoordinateReferenceSystem)crs, (boolean)false);
        return this;
    }
}

