/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.granulecollector;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Histogram;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import org.apache.commons.io.FilenameUtils;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.GranuleLoader;
import org.geotools.gce.imagemosaic.MosaicElement;
import org.geotools.gce.imagemosaic.MosaicInputs;
import org.geotools.gce.imagemosaic.Mosaicker;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.egr.ROIExcessGranuleRemover;
import org.geotools.gce.imagemosaic.granulecollector.DefaultSubmosaicProducer;
import org.geotools.gce.imagemosaic.granulecollector.SubmosaicProducer;
import org.geotools.geometry.jts.JTS;
import org.geotools.image.ImageWorker;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class BaseSubmosaicProducer
implements SubmosaicProducer {
    static final Logger LOGGER = Logging.getLogger(DefaultSubmosaicProducer.class);
    protected final List<Future<GranuleDescriptor.GranuleLoadingResult>> granulesFutures = new ArrayList<Future<GranuleDescriptor.GranuleLoadingResult>>();
    protected final boolean dryRun;
    protected RasterLayerResponse rasterLayerResponse;
    protected int granulesNumber;
    protected double[][] sourceThreshold;
    protected boolean hasAlpha;
    protected boolean doInputTransparency;
    protected Color inputTransparentColor;

    public BaseSubmosaicProducer(RasterLayerResponse rasterLayerResponse, boolean dryRun) {
        this.rasterLayerResponse = rasterLayerResponse;
        this.dryRun = dryRun;
        this.inputTransparentColor = rasterLayerResponse.getRequest().getInputTransparentColor();
        this.doInputTransparency = this.inputTransparentColor != null && !rasterLayerResponse.getFootprintBehavior().handleFootprints();
    }

    protected MosaicInputs collectGranules() throws IOException {
        if (this.granulesNumber <= 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "granules number <= 0");
            }
            return null;
        }
        StringBuilder paths = new StringBuilder();
        URL sourceUrl = null;
        ArrayList<MosaicElement> returnValues = new ArrayList<MosaicElement>();
        for (Future<GranuleDescriptor.GranuleLoadingResult> future : this.granulesFutures) {
            try {
                ROIExcessGranuleRemover remover;
                GranuleDescriptor.GranuleLoadingResult result = future.get();
                if (result == null) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "Unable to load the raster for granule with request " + this.rasterLayerResponse.getRequest().toString());
                    continue;
                }
                RenderedImage loadedImage = result.getRaster();
                if (loadedImage == null) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "Unable to load the raster for granuleDescriptor " + result.getGranuleUrl() + " with request " + this.rasterLayerResponse.getRequest().toString());
                    continue;
                }
                if (this.isMultithreadedLoadingEnabled() && (remover = this.rasterLayerResponse.getExcessGranuleRemover()) != null) {
                    if (remover.isRenderingAreaComplete()) break;
                    if (!remover.addGranule(result)) continue;
                }
                if (this.sourceThreshold == null) {
                    ColorModel cm = loadedImage.getColorModel();
                    this.hasAlpha |= cm.hasAlpha();
                    this.sourceThreshold = new double[][]{{CoverageUtilities.getMosaicThreshold((int)loadedImage.getSampleModel().getDataType())}};
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding to mosaic granule " + result.getGranuleUrl());
                }
                String fileCanonicalPath = null;
                URL url = result.getGranuleUrl();
                File inputFile = URLs.urlToFile((URL)url);
                if (inputFile != null) {
                    String canonicalPath;
                    fileCanonicalPath = canonicalPath = inputFile.getCanonicalPath();
                    if (canonicalPath.endsWith(".ovr")) {
                        fileCanonicalPath = canonicalPath.substring(0, canonicalPath.length() - 4);
                    }
                    paths.append(canonicalPath).append(",");
                } else {
                    paths.append(url.toString()).append(",");
                }
                if (sourceUrl == null) {
                    sourceUrl = result.getGranuleUrl();
                }
                MosaicElement input = this.preProcessGranuleRaster(loadedImage, result, fileCanonicalPath);
                returnValues.add(input);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Adding to mosaic failed, original request was " + this.rasterLayerResponse.getRequest());
                }
                throw new IOException(e);
            }
        }
        this.rasterLayerResponse.addGranulePaths(paths.length() > 1 ? paths.substring(0, paths.length() - 1) : "");
        this.rasterLayerResponse.setSourceUrl(sourceUrl);
        if ((returnValues == null || returnValues.isEmpty()) && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("The MosaicElement list is null or empty");
        }
        return new MosaicInputs(this.doInputTransparency, this.hasAlpha, returnValues, this.sourceThreshold);
    }

    private MosaicElement preProcessGranuleRaster(RenderedImage granule, GranuleDescriptor.GranuleLoadingResult result, String canonicalPath) {
        if (this.rasterLayerResponse.getRasterManager().isExpandMe() && granule.getColorModel() instanceof IndexColorModel) {
            granule = new ImageWorker(granule).forceComponentColorModel().getRenderedImage();
        }
        boolean granuleHasAlpha = false;
        if (this.doInputTransparency || this.hasAlpha) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on input granule " + result.getGranuleUrl());
            }
            if (this.doInputTransparency) {
                granule = new ImageWorker(granule).makeColorTransparent(this.inputTransparentColor).getRenderedImage();
            }
            granuleHasAlpha = granule.getColorModel().hasAlpha();
            if (!granule.getColorModel().hasAlpha()) {
                granule = new ImageWorker(granule).forceComponentColorModel(true).makeColorTransparent(this.inputTransparentColor).getRenderedImage();
                granuleHasAlpha = granule.getColorModel().hasAlpha();
            }
            assert (granuleHasAlpha);
        } else if (!this.rasterLayerResponse.getFootprintBehavior().handleFootprints()) {
            granuleHasAlpha = granule.getColorModel().hasAlpha();
        }
        PlanarImage alphaChannel = null;
        if (granuleHasAlpha || this.doInputTransparency) {
            ImageWorker w = new ImageWorker(granule);
            if (granule.getSampleModel() instanceof MultiPixelPackedSampleModel || granule.getColorModel() instanceof IndexColorModel) {
                w.forceComponentColorModel();
                granule = w.getRenderedImage();
            }
            int[] alphaIndex = new int[]{granule.getColorModel().getNumComponents() - 1};
            assert (alphaIndex[0] < granule.getSampleModel().getNumBands());
            alphaChannel = w.retainBands(alphaIndex).getPlanarImage();
        }
        ROIGeometry imageROI = null;
        if (this.rasterLayerResponse.getFootprintBehavior().handleFootprints() || this.rasterLayerResponse.isHeterogeneousCRS() || !JAIExt.isJAIExtOperation((String)"Mosaic")) {
            Rectangle bounds = PlanarImage.wrapRenderedImage((RenderedImage)granule).getBounds();
            Polygon mask = JTS.toGeometry(new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY()));
            imageROI = new ROIGeometry((Geometry)mask);
            ROI footprint = result.getFootprint();
            if (footprint != null) {
                imageROI = imageROI.contains(footprint.getBounds2D().getBounds()) ? footprint : imageROI.intersect(footprint);
            }
        }
        if (this.rasterLayerResponse.getFootprintBehavior().handleFootprints() && this.rasterLayerResponse.getDefaultArtifactsFilterThreshold() != Integer.MIN_VALUE && result.isDoFiltering()) {
            String baseName;
            String path;
            String histogramPath;
            Histogram histogram;
            int artifactThreshold = this.rasterLayerResponse.getDefaultArtifactsFilterThreshold();
            if (this.rasterLayerResponse.getArtifactsFilterPTileThreshold() != -1.0 && canonicalPath != null && (histogram = Utils.getHistogram(histogramPath = (path = FilenameUtils.getFullPath((String)canonicalPath)) + (baseName = FilenameUtils.getBaseName((String)canonicalPath)) + ".histogram")) != null) {
                double[] p = histogram.getPTileThreshold(this.rasterLayerResponse.getArtifactsFilterPTileThreshold());
                artifactThreshold = (int)p[0];
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Filtering granules artifacts");
            }
            ImageWorker w = new ImageWorker(granule).setRenderingHints((RenderingHints)this.rasterLayerResponse.getHints()).setROI((ROI)imageROI);
            w.setBackground(new double[]{0.0});
            w.artifactsFilter(artifactThreshold, 3);
            granule = w.getRenderedImage();
        }
        return new MosaicElement(alphaChannel, (ROI)imageROI, granule, result.getPamDataset());
    }

    @Override
    public List<MosaicElement> createMosaic() throws IOException {
        MosaicElement mosaic = new Mosaicker(this.rasterLayerResponse, this.collectGranules(), this.rasterLayerResponse.getRequest().getMergeBehavior()).createMosaic();
        if (mosaic == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(mosaic);
    }

    @Override
    public boolean accept(GranuleDescriptor granuleDescriptor) {
        return this.acceptGranule(granuleDescriptor);
    }

    protected boolean acceptGranule(GranuleDescriptor granuleDescriptor) {
        Object imageIndex;
        SimpleFeature originator = granuleDescriptor.getOriginator();
        Object object = imageIndex = originator != null ? originator.getAttribute("imageindex") : null;
        if (imageIndex != null && imageIndex instanceof Integer) {
            this.rasterLayerResponse.setImageChoice((Integer)imageIndex);
        }
        GranuleLoader loader = new GranuleLoader(this.rasterLayerResponse.getBaseReadParameters(), this.rasterLayerResponse.getImageChoice(), this.rasterLayerResponse.getMosaicBBox(), this.rasterLayerResponse.getFinalWorldToGridCorner(), granuleDescriptor, this.rasterLayerResponse.getRequest(), this.rasterLayerResponse.getHints());
        if (!this.dryRun) {
            boolean multiThreadedLoading = this.isMultithreadedLoadingEnabled();
            if (multiThreadedLoading) {
                ExecutorService mtLoader = this.rasterLayerResponse.getRasterManager().getParentReader().getMultiThreadedLoader();
                this.granulesFutures.add(mtLoader.submit(loader));
            } else {
                FutureTask<GranuleDescriptor.GranuleLoadingResult> task = new FutureTask<GranuleDescriptor.GranuleLoadingResult>(loader);
                task.run();
                ROIExcessGranuleRemover remover = this.rasterLayerResponse.getExcessGranuleRemover();
                if (remover != null) {
                    try {
                        GranuleDescriptor.GranuleLoadingResult result = task.get();
                        if (!remover.addGranule(result)) {
                            return false;
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.granulesFutures.add(task);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("We added the granule " + granuleDescriptor.toString());
        }
        ++this.granulesNumber;
        return true;
    }

    private boolean isMultithreadedLoadingEnabled() {
        ExecutorService mtLoader = this.rasterLayerResponse.getRasterManager().getParentReader().getMultiThreadedLoader();
        boolean multiThreadedLoading = this.rasterLayerResponse.isMultithreadingAllowed() && mtLoader != null;
        return multiThreadedLoading;
    }

    @Override
    public boolean doInputTransparency() {
        return this.doInputTransparency;
    }

    @Override
    public double[][] getSourceThreshold() {
        return this.sourceThreshold;
    }

    @Override
    public boolean hasAlpha() {
        return this.hasAlpha;
    }
}

