/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.egr;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.egr.Binarizator;
import org.geotools.geometry.jts.JTS;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;

public class ROIExcessGranuleRemover {
    public static final int DEFAULT_TILE_SIZE = 256;
    Binarizator binarizator;
    Rectangle rasterBounds;
    int tileWidth;
    int tileHeight;
    CoordinateReferenceSystem targetCRS;

    public ROIExcessGranuleRemover(Rectangle rasterBounds, int tileWidth, int tileHeight, CoordinateReferenceSystem targetCRS) {
        this.rasterBounds = rasterBounds;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.targetCRS = targetCRS;
    }

    public boolean addGranule(GranuleDescriptor.GranuleLoadingResult result) {
        boolean essential;
        CoordinateReferenceSystem granuleCRS = result.getGranuleDescriptor().getGranuleEnvelope().getCoordinateReferenceSystem();
        if (granuleCRS != null && this.targetCRS != null && !CRS.equalsIgnoreMetadata((Object)granuleCRS, (Object)this.targetCRS)) {
            throw new UnsupportedOperationException("Excess granule removal not yet supported with heterogeneous CRS");
        }
        if (this.binarizator != null && this.binarizator.isComplete()) {
            return false;
        }
        ROI roi = result.getFootprint();
        if (roi == null) {
            RenderedImage raster = result.getRaster();
            ColorModel cm = raster.getColorModel();
            if (cm.hasAlpha()) {
                ImageWorker w = new ImageWorker(raster);
                if (raster.getSampleModel() instanceof MultiPixelPackedSampleModel || raster.getColorModel() instanceof IndexColorModel) {
                    w.forceComponentColorModel();
                }
                int[] alphaIndex = new int[]{raster.getColorModel().getNumComponents() - 1};
                RenderedImage mask = w.retainBands(alphaIndex).binarize(127.0).getRenderedImage();
                roi = new ROI(mask);
            } else {
                Rectangle bounds = new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
                roi = new ROIShape((Shape)bounds);
            }
        }
        if (!roi.getBounds().intersects(this.rasterBounds)) {
            essential = false;
        } else {
            if (this.binarizator == null) {
                this.binarizator = new Binarizator(JTS.toPolygon(this.rasterBounds), this.rasterBounds.width, this.rasterBounds.height, this.tileWidth, this.tileHeight);
            }
            essential = this.binarizator.add(roi);
        }
        return essential;
    }

    public boolean isRenderingAreaComplete() {
        return this.binarizator != null && this.binarizator.isComplete();
    }
}

