/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.data.Repository;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.gce.imagemosaic.catalog.AbstractGTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBeans;
import org.geotools.gce.imagemosaic.catalog.DataAccessStoreWrapper;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;

public class RepositoryDataStoreCatalog
extends AbstractGTDataStoreGranuleCatalog {
    private Repository repository;
    private String flatStoreName;
    private Set<String> validTypeNames;
    private Name storeName;
    private DataAccessStoreWrapper cachedWrapped;

    public RepositoryDataStoreCatalog(Properties params, CatalogConfigurationBeans configurations, boolean create, Repository repository, String dataStoreName, DataStoreFactorySpi spi, Hints hints) {
        super(params, configurations, create, spi, hints);
        Utilities.ensureNonNull((String)"repository", (Object)repository);
        Utilities.ensureNonNull((String)"dataStoreName", (Object)repository);
        this.repository = repository;
        this.flatStoreName = dataStoreName;
        this.storeName = RepositoryDataStoreCatalog.buildName(dataStoreName);
    }

    static Name buildName(String name) {
        int idx = name.indexOf(":");
        if (idx == -1) {
            return new NameImpl(name);
        }
        String ns = name.substring(0, idx);
        String local = name.substring(idx + 1);
        return new NameImpl(ns, local);
    }

    @Override
    protected void handleInitializationException(Throwable t) {
    }

    @Override
    protected void initTileIndexStore(Properties params, boolean create, DataStoreFactorySpi spi) throws IOException, MalformedURLException {
        if (create) {
            this.validTypeNames = new HashSet<String>();
        }
    }

    @Override
    protected void disposeTileIndexStore() {
    }

    @Override
    protected DataStore getTileIndexStore() {
        DataStore dataStore = null;
        try {
            dataStore = this.repository.dataStore(this.storeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataStore == null) {
            DataAccess<FeatureType, Feature> access = this.repository.access(this.storeName);
            if (access != null) {
                DataAccessStoreWrapper wrapper;
                if (this.cachedWrapped != null && this.cachedWrapped.wraps(access)) {
                    return this.cachedWrapped;
                }
                this.cachedWrapped = wrapper = new DataAccessStoreWrapper(access);
                dataStore = wrapper;
            } else {
                throw new IllegalStateException("Could not find a data store with name " + this.flatStoreName);
            }
        }
        return dataStore;
    }

    @Override
    protected Set<String> getValidTypeNames() {
        if (this.validTypeNames == null) {
            this.validTypeNames = new HashSet<String>();
            try {
                this.initializeTypeNames(this.params);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.validTypeNames;
    }
}

