/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.io.FilenameUtils;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.AbstractGTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBeans;
import org.geotools.gce.imagemosaic.catalog.oracle.OracleDatastoreWrapper;
import org.geotools.gce.imagemosaic.catalog.postgis.PostgisDatastoreWrapper;
import org.geotools.gce.imagemosaic.catalog.sqlserver.SQLServerDatastoreWrapper;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;

public class GTDataStoreGranuleCatalog
extends AbstractGTDataStoreGranuleCatalog {
    private DataStore tileIndexStore;
    private Set<String> validTypeNames;

    public GTDataStoreGranuleCatalog(Properties params, CatalogConfigurationBeans configurations, boolean create, DataStoreFactorySpi spi, Hints hints) {
        super(params, configurations, create, spi, hints);
    }

    @Override
    protected void initTileIndexStore(Properties params, boolean create, DataStoreFactorySpi spi) throws IOException, MalformedURLException {
        Utilities.ensureNonNull((String)"spi", (Object)spi);
        Map<String, Serializable> dastastoreParams = Utils.filterDataStoreParams(params, spi);
        boolean isPostgis = Utils.isPostgisStore(spi);
        if (Utils.isH2Store(spi)) {
            Utils.fixH2DatabaseLocation(dastastoreParams, this.parentLocation);
            Utils.fixH2MVCCParam(dastastoreParams);
        }
        if (isPostgis) {
            Utils.fixPostgisDBCreationParams(dastastoreParams);
        }
        if (!create) {
            this.tileIndexStore = spi.createDataStore((Map)dastastoreParams);
        } else {
            try {
                this.tileIndexStore = spi.createNewDataStore(dastastoreParams);
            }
            catch (UnsupportedOperationException e) {
                this.tileIndexStore = spi.createDataStore((Map)dastastoreParams);
            }
        }
        if (isPostgis && this.wrapstore) {
            this.tileIndexStore = new PostgisDatastoreWrapper(this.getTileIndexStore(), FilenameUtils.getFullPath((String)this.parentLocation));
        } else if (Utils.isOracleStore(spi)) {
            this.tileIndexStore = new OracleDatastoreWrapper(this.getTileIndexStore(), FilenameUtils.getFullPath((String)this.parentLocation));
        } else if (Utils.isSQLServerStore(spi)) {
            this.tileIndexStore = new SQLServerDatastoreWrapper(this.getTileIndexStore(), FilenameUtils.getFullPath((String)this.parentLocation));
        }
        this.validTypeNames = new HashSet<String>();
        if (create) {
            return;
        }
        this.initializeTypeNames(params);
    }

    @Override
    protected void handleInitializationException(Throwable t) {
        try {
            if (this.tileIndexStore != null) {
                this.tileIndexStore.dispose();
            }
        }
        catch (Throwable e1) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
            }
        }
        finally {
            this.tileIndexStore = null;
        }
    }

    @Override
    protected DataStore getTileIndexStore() {
        return this.tileIndexStore;
    }

    @Override
    protected void disposeTileIndexStore() {
        try {
            if (this.tileIndexStore != null) {
                this.tileIndexStore.dispose();
            }
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        finally {
            this.tileIndexStore = null;
        }
    }

    @Override
    protected Set<String> getValidTypeNames() {
        return this.validTypeNames;
    }
}

