/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.util.Converters;
import org.geotools.util.DateRange;
import org.geotools.util.Range;
import org.geotools.util.Utilities;

class RangeVisitor
implements FeatureCalc {
    protected Expression expr1;
    protected Expression expr2;
    private Comparator<? extends Range> comparator;
    Set<Range> set = null;
    Set<String> minimalRanges = null;

    public RangeVisitor(String attributeTypeName1, String attributeTypeName2) {
        this(attributeTypeName1, attributeTypeName2, RangeType.NUMBER);
    }

    public RangeVisitor(String attributeTypeName1, String attributeTypeName2, RangeType rangeType) {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr1 = factory.property(attributeTypeName1);
        this.expr2 = factory.property(attributeTypeName2);
        this.comparator = rangeType == RangeType.NUMBER ? new NumberRangeComparator() : new DateRangeComparator();
        this.set = this.buildSet();
    }

    private TreeSet<Range> buildSet() {
        return new TreeSet<Range>(this.comparator);
    }

    public void init(SimpleFeatureCollection collection) {
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        Object firstValue = this.expr1.evaluate((Object)feature);
        Object secondValue = this.expr2.evaluate((Object)feature);
        if (firstValue != null && secondValue != null) {
            this.set.add(Utils.createRange(firstValue, secondValue));
        }
    }

    public void setValue(Object newSet) {
        if (newSet instanceof Collection) {
            Collection cast = (Collection)newSet;
            this.set = new HashSet<Range>(cast);
        } else {
            Collection collection = (Collection)Converters.convert((Object)newSet, List.class);
            if (collection != null) {
                this.set = new HashSet<Range>(collection);
            } else {
                Set<Range> singleton = Collections.singleton((Range)newSet);
                this.set = new HashSet<Range>(singleton);
            }
        }
    }

    public void reset() {
        this.set = this.buildSet();
        this.minimalRanges = null;
    }

    public Set<String> getRange() {
        if (this.minimalRanges == null) {
            this.minimalRanges = new LinkedHashSet<String>();
            this.populateRange();
        }
        return this.minimalRanges;
    }

    protected void populateRange() {
        for (Range range : this.set) {
            this.minimalRanges.add(range.getMinValue() + "/" + range.getMaxValue());
        }
    }

    @Override
    public CalcResult getResult() {
        if (this.set.isEmpty()) {
            return CalcResult.NULL_RESULT;
        }
        return new RangeResult(this.set);
    }

    static class RangeResult
    extends AbstractCalcResult {
        private Set<Range> ranges;

        public RangeResult(Set<Range> newSet) {
            this.ranges = newSet;
        }

        @Override
        public Object getValue() {
            return new HashSet<Range>(this.ranges);
        }

        @Override
        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof RangeResult || targetResults == CalcResult.NULL_RESULT;
        }

        @Override
        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof RangeResult) {
                HashSet<Range> newSet = new HashSet<Range>(this.ranges);
                Set other = (Set)resultsToAdd.getValue();
                newSet.addAll(other);
                return new RangeResult(newSet);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }

    static class NumberRangeComparator
    implements Comparator<Range<? extends Number>> {
        NumberRangeComparator() {
        }

        @Override
        public int compare(Range<? extends Number> firstRange, Range<? extends Number> secondRange) {
            Utilities.ensureNonNull((String)"firstRange", firstRange);
            Utilities.ensureNonNull((String)"secondRange", secondRange);
            Number firstRangeMin = (Number)((Object)firstRange.getMinValue());
            Number firstRangeMax = (Number)((Object)firstRange.getMaxValue());
            Number secondRangeMin = (Number)((Object)secondRange.getMinValue());
            Number secondRangeMax = (Number)((Object)secondRange.getMaxValue());
            return NumberRangeComparator.doubleCompare(firstRangeMin.doubleValue(), firstRangeMax.doubleValue(), secondRangeMin.doubleValue(), secondRangeMax.doubleValue());
        }

        public static int doubleCompare(double firstRangeMin, double firstRangeMax, double secondRangeMin, double secondRangeMax) {
            if (firstRangeMin == secondRangeMin && firstRangeMax == secondRangeMax) {
                return 0;
            }
            if (firstRangeMin > secondRangeMin) {
                if (firstRangeMax > secondRangeMax) {
                    return 2;
                }
                return 1;
            }
            if (firstRangeMax <= secondRangeMax) {
                return -2;
            }
            return -1;
        }
    }

    class DateRangeComparator
    implements Comparator<DateRange> {
        DateRangeComparator() {
        }

        @Override
        public int compare(DateRange firstDateRange, DateRange secondDateRange) {
            Utilities.ensureNonNull((String)"firstDateRange", (Object)firstDateRange);
            Utilities.ensureNonNull((String)"secondDateRange", (Object)secondDateRange);
            long beginFirst = firstDateRange.getMinValue().getTime();
            long endFirst = firstDateRange.getMaxValue().getTime();
            long beginSecond = secondDateRange.getMinValue().getTime();
            long endSecond = secondDateRange.getMaxValue().getTime();
            return NumberRangeComparator.doubleCompare(beginFirst, endFirst, beginSecond, endSecond);
        }
    }

    static enum RangeType {
        NUMBER,
        DATE;

    }
}

