/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DefaultTransaction;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

abstract class ImageMosaicWalker<T>
implements Runnable {
    static final Logger LOGGER = Logging.getLogger(ImageMosaicWalker.class);
    protected DefaultTransaction transaction;
    protected volatile boolean stop = false;
    protected final ImageMosaicConfigHandler configHandler;
    protected final ImageMosaicEventHandlers eventHandler;
    protected int elementIndex = 0;
    protected int numElements = 1;

    public ImageMosaicConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public ImageMosaicEventHandlers getEventHandler() {
        return this.eventHandler;
    }

    public DefaultTransaction getTransaction() {
        return this.transaction;
    }

    public ImageMosaicWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler) {
        Utilities.ensureNonNull((String)"config handler", (Object)configHandler);
        Utilities.ensureNonNull((String)"event handler", (Object)eventHandler);
        this.configHandler = configHandler;
        this.eventHandler = eventHandler;
    }

    public boolean getStop() {
        return this.stop;
    }

    public void stop() {
        this.stop = true;
    }

    public void startTransaction() {
        if (this.transaction != null) {
            throw new IllegalStateException("Transaction already open!");
        }
        this.transaction = new DefaultTransaction("MosaicCreationTransaction" + System.nanoTime());
    }

    public void rollbackTransaction() throws IOException {
        this.transaction.rollback();
    }

    public void commitTransaction() throws IOException {
        this.transaction.commit();
    }

    public void closeTransaction() {
        this.transaction.close();
    }

    protected boolean checkStop() {
        if (this.getStop()) {
            this.eventHandler.fireEvent(Level.INFO, "Stopping requested at file  " + this.elementIndex + " of " + this.numElements + " files", (double)this.elementIndex * 100.0 / (double)this.numElements);
            return false;
        }
        return true;
    }

    public int getElementIndex() {
        return this.elementIndex;
    }

    public int getNumElements() {
        return this.numElements;
    }

    public void setElementIndex(int elementIndex) {
        this.elementIndex = elementIndex;
    }

    public void setNumElements(int numElements) {
        this.numElements = numElements;
    }

    public void skip(String path) {
        LOGGER.log(Level.INFO, "Unable to use path: " + path + " - skipping it.");
        ++this.elementIndex;
    }
}

