/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.RenderingHints;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.renderer.i18n.ErrorKeys;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.util.factory.Hints;

public abstract class BaseCoverageProcessingNode
implements CoverageProcessingNode {
    private static final CoverageProcessingCycleDetector cycleDetector = new CoverageProcessingCycleDetector();
    private static final Logger LOGGER = Logger.getLogger(BaseCoverageProcessingNode.class.getName());
    private final List<CoverageProcessingNode> sources = new ArrayList<CoverageProcessingNode>();
    private final List<CoverageProcessingNode> sinks = new ArrayList<CoverageProcessingNode>();
    private GridCoverage2D output;
    private boolean executed = false;
    private int maximumNumberOfSources = -1;
    private Hints hints;
    final GridCoverageFactory coverageFactory;
    private Throwable error;
    private boolean disposed;
    private InternationalString name = Vocabulary.formatInternational(3);
    private InternationalString description;

    public BaseCoverageProcessingNode(InternationalString name, InternationalString description) {
        this(-1, name, description);
    }

    public BaseCoverageProcessingNode(int maxSources, InternationalString name, InternationalString description) {
        this(maxSources, null, name, description);
    }

    public BaseCoverageProcessingNode(int maxSources, Hints hints, InternationalString name, InternationalString description) {
        BaseCoverageProcessingNode.ensureNotNull(name, "CoverageProcessingNode name ");
        BaseCoverageProcessingNode.ensureNotNull(description, "CoverageProcessingNode descripion ");
        this.maximumNumberOfSources = maxSources;
        this.hints = hints != null ? hints.clone() : null;
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)hints);
        this.name = name;
        this.description = description;
    }

    private void checkExecuted() {
        if (this.disposed) {
            this.error = new CoverageProcessingException("Trying to process a disposed CoverageProcessingNode.");
            return;
        }
        if (!this.executed) {
            try {
                this.output = null;
                GridCoverage result = this.execute();
                if (result == null) {
                    this.error = new CoverageProcessingException("Something bad occurred while trying to execute this node.");
                }
                if (!(result instanceof GridCoverage2D)) {
                    this.error = new CoverageProcessingException("Something bad occurred while trying to execute this node.");
                }
                if (this.error == null) {
                    this.output = (GridCoverage2D)result;
                }
            }
            catch (Throwable t) {
                Logger.getGlobal().log(Level.INFO, "", t);
                this.output = null;
                this.error = t;
            }
            this.executed = true;
        }
        assert (this.executed);
    }

    protected abstract GridCoverage execute();

    @Override
    public void dispose(boolean force) {
        if (this.disposed) {
            return;
        }
        if (this.output != null) {
            this.output.dispose(force);
        }
        for (CoverageProcessingNode source : this.sources) {
            source.removeSink(this);
        }
        this.sources.clear();
        this.sinks.clear();
        this.disposed = true;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("disposed node \n" + this.toString());
        }
    }

    public GridCoverage2D getOutput() throws CoverageProcessingException {
        this.checkExecuted();
        if (this.error != null) {
            throw new CoverageProcessingException(this.error);
        }
        return this.output;
    }

    @Override
    public void addSink(CoverageProcessingNode sink) {
        BaseCoverageProcessingNode.ensureNotNull(sink, "CoverageProcessingNode");
        this.sinks.add(sink);
        this.detectCycle();
    }

    private void cleanOutput() {
        if (this.executed) {
            this.executed = false;
            this.output.dispose(true);
            this.error = null;
        }
    }

    @Override
    public boolean addSource(CoverageProcessingNode source) {
        BaseCoverageProcessingNode.ensureNotNull(source, "CoverageProcessingNode");
        this.checkNumSources(1);
        if (this.sources.add(source)) {
            this.cleanOutput();
            this.detectCycle();
            return true;
        }
        return false;
    }

    private void detectCycle() throws IllegalStateException {
        if (cycleDetector.detectCycle(this)) {
            throw new IllegalStateException(ErrorKeys.CYCLE_DETECTED);
        }
    }

    private void checkNumSources(int sourcesToAdd) {
        if (this.maximumNumberOfSources != -1 && this.sources.size() + sourcesToAdd > this.maximumNumberOfSources) {
            throw new IllegalStateException(MessageFormat.format(ErrorKeys.TOO_MANY_SOURCES_$1, this.maximumNumberOfSources));
        }
    }

    @Override
    public CoverageProcessingNode getSink(int index) {
        return this.sinks.get(index);
    }

    @Override
    public List<CoverageProcessingNode> getSinks() {
        return Collections.unmodifiableList(this.sinks);
    }

    @Override
    public CoverageProcessingNode getSource(int index) {
        return this.sources.get(index);
    }

    @Override
    public List<CoverageProcessingNode> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    @Override
    public boolean removeSink(CoverageProcessingNode sink) {
        BaseCoverageProcessingNode.ensureNotNull(sink, "CoverageProcessingNode");
        return this.sinks.remove(sink);
    }

    @Override
    public CoverageProcessingNode removeSink(int index) {
        return this.sinks.remove(index);
    }

    @Override
    public boolean removeSource(CoverageProcessingNode source) {
        BaseCoverageProcessingNode.ensureNotNull(source, "CoverageProcessingNode");
        boolean success = this.sources.remove(source);
        if (success) {
            this.cleanOutput();
        }
        return success;
    }

    @Override
    public Hints getHints() {
        return new Hints((RenderingHints)this.hints);
    }

    public int getMaximumNumberOfSources() {
        return this.maximumNumberOfSources;
    }

    @Override
    public GridCoverageFactory getCoverageFactory() {
        return this.coverageFactory;
    }

    @Override
    public int getNumberOfSinks() {
        return this.sinks.size();
    }

    @Override
    public int getNumberOfSources() {
        return this.sources.size();
    }

    @Override
    public InternationalString getDescription() {
        return this.description;
    }

    @Override
    public InternationalString getName() {
        return this.name;
    }

    protected static void ensureSourceNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.SOURCE_CANT_BE_NULL_$1, name));
        }
    }

    protected static void ensureNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(MessageFormat.format(ErrorKeys.NULL_ARGUMENT_$1, name));
        }
    }

    @Override
    public CoverageProcessingNode removeSource(int index) throws IndexOutOfBoundsException {
        return this.sources.remove(index);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Node Name:").append(this.getName().toString()).append("\n");
        buffer.append("Node Description:").append(this.getDescription().toString()).append("\n");
        return buffer.toString();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    private static final class CoverageProcessingCycleDetector {
        public boolean detectCycle(CoverageProcessingNode startPoint) {
            return this.check(startPoint, startPoint);
        }

        private boolean check(CoverageProcessingNode baseNode, CoverageProcessingNode currentNode) {
            if (currentNode.getNumberOfSinks() == 0) {
                return false;
            }
            List<CoverageProcessingNode> sinks = currentNode.getSinks();
            for (CoverageProcessingNode node : sinks) {
                if (baseNode.equals(node)) {
                    return true;
                }
                if (!this.check(baseNode, node)) continue;
                return true;
            }
            return false;
        }
    }
}

