/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.xml;

import java.io.Reader;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.util.EntityResolverProvider;
import org.geotools.util.Version;
import org.geotools.wcs.v2_0.WCSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.vfny.geoserver.wcs.WcsException;

public class WcsXmlReader
extends XmlRequestReader {
    WCSConfiguration configuration;
    private EntityResolverProvider resolverProvider;

    public WcsXmlReader(String element, String version, WCSConfiguration configuration, EntityResolverProvider resolverProvider) {
        super(new QName("http://www.opengis.net/wcs/2.0", element), new Version(version), "wcs");
        this.configuration = configuration;
        this.resolverProvider = resolverProvider;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        Object parsed;
        Parser parser = new Parser((Configuration)this.configuration);
        parser.setEntityResolver(this.resolverProvider.getEntityResolver());
        try {
            parsed = parser.parse(reader);
        }
        catch (Exception e) {
            throw new WcsException("Parsing failed, the xml request is most probably not compliant to the wcs 2.0.1 schema", (Throwable)this.cleanException(e));
        }
        return parsed;
    }
}

