/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.opengis.wcs20.ExtensionItemType;
import net.opengis.wcs20.ExtensionType;
import net.opengis.wcs20.GetCoverageType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.wcs.responses.CoverageEncoder;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs2_0.response.FileReference;
import org.geoserver.wcs2_0.response.GMLCovHandler;
import org.geoserver.wcs2_0.util.EnvelopeAxesLabelsMapper;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.vfny.geoserver.wcs.WcsException;

public class WCS20GetCoverageMultipartResponse
extends Response {
    CoverageResponseDelegateFinder responseFactory;
    EnvelopeAxesLabelsMapper envelopeDimensionsMapper;

    public WCS20GetCoverageMultipartResponse(CoverageResponseDelegateFinder responseFactory, EnvelopeAxesLabelsMapper envelopeDimensionsMapper) {
        super(GridCoverage.class);
        this.responseFactory = responseFactory;
        this.envelopeDimensionsMapper = envelopeDimensionsMapper;
    }

    public String getPreferredDisposition(Object value, Operation operation) {
        return "attachment";
    }

    public String getMimeType(Object value, Operation operation) {
        return "multipart/related";
    }

    public boolean canHandle(Operation operation) {
        Object firstParam = operation.getParameters()[0];
        if (!(firstParam instanceof GetCoverageType)) {
            return false;
        }
        GetCoverageType getCoverage = (GetCoverageType)firstParam;
        String mediaType = getCoverage.getMediaType();
        return mediaType != null && mediaType.equals("multipart/related");
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException {
        GridCoverage2D coverage = (GridCoverage2D)value;
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        String format = getCoverage.getFormat();
        if (format == null) {
            format = "image/tiff";
        }
        HashMap<String, String> encodingParameters = new HashMap<String, String>();
        ExtensionType extension = getCoverage.getExtension();
        if (extension != null) {
            EList extensions = extension.getContents();
            for (ExtensionItemType ext : extensions) {
                encodingParameters.put(ext.getName(), ext.getSimpleContent());
            }
        }
        CoverageResponseDelegate delegate = this.responseFactory.encoderFor(format);
        try {
            MimeMultipart multipart = new MimeMultipart();
            multipart.setSubType("related");
            String fileName = "/coverages/" + getCoverage.getCoverageId() + "." + delegate.getFileExtension(format);
            MimeBodyPart coveragesPart = new MimeBodyPart();
            FileReference reference = new FileReference(fileName, delegate.getMimeType(format), delegate.getConformanceClass(format));
            GMLCovHandler.CoverageData coveragesData = new GMLCovHandler.CoverageData(coverage, reference, this.envelopeDimensionsMapper);
            coveragesPart.setDataHandler(new DataHandler((Object)coveragesData, "geoserver/coverages20"));
            coveragesPart.setHeader("Content-ID", "wcs");
            coveragesPart.setHeader("Content-Type", "application/gml+xml");
            multipart.addBodyPart((BodyPart)coveragesPart);
            MimeBodyPart coveragePart = new MimeBodyPart();
            CoverageEncoder encoder = new CoverageEncoder(delegate, coverage, format, encodingParameters);
            coveragePart.setDataHandler(new DataHandler((Object)encoder, "geoserver/coverageDelegate"));
            coveragePart.setHeader("Content-ID", fileName);
            coveragePart.setHeader("Content-Type", delegate.getMimeType(format));
            coveragePart.setHeader("Content-Transfer-Encoding", "binary");
            multipart.addBodyPart((BodyPart)coveragePart);
            GeoServerMimeMessage message = new GeoServerMimeMessage();
            message.setContent((Multipart)multipart);
            message.writeTo(output);
            output.flush();
        }
        catch (MessagingException e) {
            throw new WcsException("Error occurred while encoding the mime multipart response", (Throwable)e);
        }
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        return getCoverage.getCoverageId() + ".eml";
    }

    private static class GeoServerMimeMessage
    extends MimeMessage {
        public GeoServerMimeMessage() {
            super((Session)null);
        }

        protected void updateMessageID() throws MessagingException {
            this.removeHeader("Message-ID");
        }
    }
}

