/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CatalogVisitorAdapter;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs2_0.response.CoverageMimeTypeMapper;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MIMETypeMapper
implements ApplicationContextAware {
    private static final String NO_MIME_TYPE = "NoMimeType";
    public static final String DEFAULT_FORMAT = "image/tiff";
    private Logger LOGGER = Logging.getLogger(MIMETypeMapper.class);
    private final SoftValueHashMap<String, String> mimeTypeCache = new SoftValueHashMap(100);
    private final Set<String> outputMimeTypes = new HashSet<String>();
    private List<CoverageMimeTypeMapper> mappers;

    private MIMETypeMapper(CoverageResponseDelegateFinder finder, Catalog catalog) {
        for (String of : finder.getOutputFormats()) {
            CoverageResponseDelegate delegate = finder.encoderFor(of);
            String mime = delegate.getMimeType(of);
            this.outputMimeTypes.add(mime);
        }
        catalog.addListener((CatalogListener)new MimeTypeCacheClearingListener());
    }

    public String mapNativeFormat(CoverageInfo cInfo) throws IOException {
        CoverageMimeTypeMapper mapper;
        Utilities.ensureNonNull((String)"cInfo", (Object)cInfo);
        String mime = (String)this.mimeTypeCache.get((Object)cInfo.getId());
        if (mime != null) {
            if (NO_MIME_TYPE.equals(mime)) {
                return DEFAULT_FORMAT;
            }
            return mime;
        }
        Iterator<CoverageMimeTypeMapper> iterator = this.mappers.iterator();
        while (iterator.hasNext() && (mime = (mapper = iterator.next()).getMimeType(cInfo)) == null) {
        }
        if (mime != null && this.outputMimeTypes.contains(mime)) {
            this.mimeTypeCache.put((Object)cInfo.getId(), (Object)mime);
            if (this.LOGGER.isLoggable(Level.FINE)) {
                this.LOGGER.fine("Added mapping for mime: " + mime);
            }
            return mime;
        }
        this.mimeTypeCache.put((Object)cInfo.getId(), (Object)NO_MIME_TYPE);
        return DEFAULT_FORMAT;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mappers = GeoServerExtensions.extensions(CoverageMimeTypeMapper.class, (ApplicationContext)applicationContext);
    }

    public class MimeTypeCacheClearingListener
    extends CatalogVisitorAdapter
    implements CatalogListener {
        public void handleAddEvent(CatalogAddEvent event) {
        }

        public void handleModifyEvent(CatalogModifyEvent event) {
        }

        public void handlePostModifyEvent(CatalogPostModifyEvent event) {
            event.getSource().accept((CatalogVisitor)this);
        }

        public void handleRemoveEvent(CatalogRemoveEvent event) {
            event.getSource().accept((CatalogVisitor)this);
        }

        public void reloaded() {
            MIMETypeMapper.this.outputMimeTypes.clear();
        }

        public void visit(CoverageInfo coverage) {
            MIMETypeMapper.this.outputMimeTypes.remove(coverage.getId());
        }
    }
}

