/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.List;
import net.opengis.wcs20.ScaleToSizeType;
import net.opengis.wcs20.TargetAxisSizeType;
import net.opengis.wcs20.Wcs20Factory;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.kvp.AbstractAxisValueKvpParser;

public class ScaleSizeKvpParser
extends AbstractAxisValueKvpParser<TargetAxisSizeType> {
    public ScaleSizeKvpParser() {
        super("scalesize", ScaleToSizeType.class);
    }

    public Object parse(String value) throws Exception {
        ScaleToSizeType sabf = Wcs20Factory.eINSTANCE.createScaleToSizeType();
        List items = this.parseItem(value);
        sabf.getTargetAxisSize().addAll(items);
        return sabf;
    }

    @Override
    protected TargetAxisSizeType buildItem(String axisName, String value) {
        TargetAxisSizeType tas = Wcs20Factory.eINSTANCE.createTargetAxisSizeType();
        try {
            tas.setAxis(axisName.trim());
            tas.setTargetSize(Double.valueOf(value).doubleValue());
        }
        catch (NumberFormatException e) {
            this.throwInvalidSyntaxException(null);
        }
        return tas;
    }

    @Override
    protected void throwInvalidSyntaxException(Exception e) {
        WCS20Exception ex = new WCS20Exception("Invalid ScaleSize syntax, expecting a comma separate list of axisName(size)*", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "scaleSize");
        if (e != null) {
            ex.initCause(e);
        }
        throw ex;
    }
}

