/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import net.opengis.wcs20.ScaleToExtentType;
import net.opengis.wcs20.TargetAxisExtentType;
import net.opengis.wcs20.Wcs20Factory;
import org.geoserver.ows.KvpParser;
import org.geoserver.wcs2_0.exception.WCS20Exception;

public class ScaleExtentKvpParser
extends KvpParser {
    public ScaleExtentKvpParser() {
        super("scaleExtent", ScaleToExtentType.class);
    }

    public Object parse(String value) throws Exception {
        value = value.trim();
        ScaleToExtentType se = Wcs20Factory.eINSTANCE.createScaleToExtentType();
        int base = 0;
        while (true) {
            int idxOpen;
            if ((idxOpen = value.indexOf("(", base)) == -1) {
                throw new WCS20Exception("Invalid ScaleExtent syntax, expecting a comma separate list of axisName(min,max)*", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "scaleExtent");
            }
            int idxNextOpen = value.indexOf("(", idxOpen + 1);
            int idxClosed = value.indexOf(")", idxOpen);
            if (idxClosed == -1 || idxNextOpen > 0 && idxClosed > idxNextOpen) {
                throw new WCS20Exception("Invalid ScaleExtent syntax, expecting a comma separate list of axisName(min,max)*", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "scaleExtent");
            }
            int idxNextClosed = value.indexOf(")", idxClosed + 1);
            int idxMid = value.indexOf(",", base);
            if (idxMid == -1 || idxMid >= idxClosed - 1 || idxMid <= idxOpen + 1) {
                throw new WCS20Exception("Invalid ScaleExtent syntax, expecting a comma separate list of axisName(min,max)*", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "scaleExtent");
            }
            int idxNextMid = value.indexOf(",", idxMid + 1);
            if (idxNextMid != -1 && idxNextMid < idxClosed) {
                throw new WCS20Exception("Invalid ScaleExtent syntax, expecting a comma separate list of axisName(min,max)*", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "scaleExtent");
            }
            String axisName = value.substring(base, idxOpen);
            String low = value.substring(idxOpen + 1, idxMid);
            String high = value.substring(idxMid + 1, idxClosed);
            try {
                TargetAxisExtentType te = Wcs20Factory.eINSTANCE.createTargetAxisExtentType();
                te.setAxis(axisName.trim());
                te.setLow(Double.valueOf(low).doubleValue());
                te.setHigh(Double.valueOf(high).doubleValue());
                se.getTargetAxisExtent().add((Object)te);
            }
            catch (NumberFormatException e) {
                WCS20Exception ex = new WCS20Exception("Invalid ScaleExtent syntax, expecting a comma separate list of axisName(min,max)*", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "scaleExtent");
                ex.initCause(e);
                throw ex;
            }
            int idxSeparator = value.indexOf(",", idxClosed);
            if (idxSeparator == -1) {
                if (idxClosed == value.length() - 1) {
                    return se;
                }
                throw new WCS20Exception("Invalid ScaleExtent syntax, expecting a comma separate list of axisName(min,max)*", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "scaleExtent");
            }
            if (idxSeparator > idxNextClosed) {
                throw new WCS20Exception("Invalid ScaleExtent syntax, expecting a comma separate list of axisName(min,max)*", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "scaleExtent");
            }
            base = idxSeparator + 1;
        }
    }
}

