/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.exception;

import java.util.List;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.Service;
import org.geoserver.wcs2_0.exception.OWS20ServiceExceptionHandler;

public class WCS20ServiceExceptionHandler
extends OWS20ServiceExceptionHandler {
    public static final String WCS20_NAMESPACE = "http://www.opengis.net/wcs/2.0";

    public WCS20ServiceExceptionHandler(Service service) {
        super(service);
    }

    public boolean canHandle(Service service, Request request) {
        List supportedVersions;
        if (request.isGet() && "WCS".equalsIgnoreCase(request.getService()) && !"GetCapabilities".equalsIgnoreCase(request.getRequest()) && !(supportedVersions = RequestUtils.getSupportedVersions((String)"WCS")).contains(request.getVersion())) {
            return request.getRawKvp().containsKey("coverageId");
        }
        return super.canHandle(service, request) || WCS20_NAMESPACE.equals(request.getNamespace());
    }
}

