/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import net.opengis.wcs20.GetCapabilitiesType;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs2_0.DefaultWebCoverageService20;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.response.WCS20GetCapabilitiesTransformer;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;

public class GetCapabilities {
    protected Logger LOGGER = Logging.getLogger(DefaultWebCoverageService20.class);
    private WCSInfo wcs;
    private CoverageResponseDelegateFinder responseFactory;
    public static final List<String> PROVIDED_VERSIONS = Collections.unmodifiableList(Arrays.asList("2.0.1", "2.0.0", "1.1.1", "1.1.0"));

    public GetCapabilities(WCSInfo wcs, CoverageResponseDelegateFinder responseFactory) {
        this.wcs = wcs;
        this.responseFactory = responseFactory;
    }

    TransformerBase run(GetCapabilitiesType request) throws WCS20Exception {
        WCS20GetCapabilitiesTransformer capsTransformer = new WCS20GetCapabilitiesTransformer(this.wcs.getGeoServer(), this.responseFactory);
        capsTransformer.setEncoding(Charset.forName(this.wcs.getGeoServer().getSettings().getCharset()));
        return capsTransformer;
    }
}

