/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.opengis.wcs20.DescribeCoverageType;
import net.opengis.wcs20.DescribeEOCoverageSetType;
import net.opengis.wcs20.GetCapabilitiesType;
import net.opengis.wcs20.GetCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs2_0.GetCapabilities;
import org.geoserver.wcs2_0.GetCoverage;
import org.geoserver.wcs2_0.WebCoverageService20;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.response.MIMETypeMapper;
import org.geoserver.wcs2_0.response.WCS20DescribeCoverageTransformer;
import org.geoserver.wcs2_0.util.EnvelopeAxesLabelsMapper;
import org.geoserver.wcs2_0.util.NCNameResourceCodec;
import org.geoserver.wcs2_0.util.RequestUtils;
import org.geoserver.wcs2_0.util.StringUtils;
import org.geoserver.wcs2_0.util.WCS20DescribeCoverageExtension;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;

public class DefaultWebCoverageService20
implements WebCoverageService20 {
    protected Logger LOGGER = Logging.getLogger(DefaultWebCoverageService20.class);
    private MIMETypeMapper mimeMapper;
    private Catalog catalog;
    private GeoServer geoServer;
    private CoverageResponseDelegateFinder responseFactory;
    private EnvelopeAxesLabelsMapper envelopeAxesMapper;
    private List<WCS20DescribeCoverageExtension> wcsDescribeCoverageExtensions;
    private boolean availableDescribeCovExtensions;

    public DefaultWebCoverageService20(GeoServer geoServer, CoverageResponseDelegateFinder responseFactory, EnvelopeAxesLabelsMapper envelopeDimensionsMapper, MIMETypeMapper mimemappe) {
        this.geoServer = geoServer;
        this.catalog = geoServer.getCatalog();
        this.responseFactory = responseFactory;
        this.envelopeAxesMapper = envelopeDimensionsMapper;
        this.mimeMapper = mimemappe;
        this.wcsDescribeCoverageExtensions = GeoServerExtensions.extensions(WCS20DescribeCoverageExtension.class);
        this.availableDescribeCovExtensions = this.wcsDescribeCoverageExtensions != null && !this.wcsDescribeCoverageExtensions.isEmpty();
    }

    @Override
    public WCSInfo getServiceInfo() {
        return (WCSInfo)this.geoServer.getService(WCSInfo.class);
    }

    @Override
    public TransformerBase getCapabilities(GetCapabilitiesType request) {
        RequestUtils.checkService(request.getService());
        return new GetCapabilities(this.getServiceInfo(), this.responseFactory).run(request);
    }

    @Override
    public WCS20DescribeCoverageTransformer describeCoverage(DescribeCoverageType request) {
        RequestUtils.checkService(request.getService());
        RequestUtils.checkVersion(request.getVersion());
        if (request.getCoverageId() == null || request.getCoverageId().isEmpty()) {
            throw new OWS20Exception("Required parameter coverageId missing", (OWS20Exception.OWSExceptionCode)WCS20Exception.WCS20ExceptionCode.EmptyCoverageIdList, "coverageId");
        }
        ArrayList<String> badCoverageIds = new ArrayList<String>();
        Iterator iterator = request.getCoverageId().iterator();
        while (iterator.hasNext()) {
            LayerInfo layer;
            String encodedCoverageId;
            String newCoverageID = encodedCoverageId = (String)iterator.next();
            if (this.availableDescribeCovExtensions) {
                for (WCS20DescribeCoverageExtension ext : this.wcsDescribeCoverageExtensions) {
                    newCoverageID = ext.handleCoverageId(newCoverageID);
                }
            }
            if ((layer = NCNameResourceCodec.getCoverage(this.catalog, newCoverageID)) != null) continue;
            badCoverageIds.add(encodedCoverageId);
        }
        if (!badCoverageIds.isEmpty()) {
            String mergedIds = StringUtils.merge(badCoverageIds);
            throw new WCS20Exception("Could not find the requested coverage(s): " + mergedIds, WCS20Exception.WCS20ExceptionCode.NoSuchCoverage, "coverageId");
        }
        WCSInfo wcs = this.getServiceInfo();
        WCS20DescribeCoverageTransformer describeTransformer = new WCS20DescribeCoverageTransformer(this.catalog, this.envelopeAxesMapper, this.mimeMapper);
        describeTransformer.setEncoding(Charset.forName(wcs.getGeoServer().getSettings().getCharset()));
        return describeTransformer;
    }

    @Override
    public GridCoverage getCoverage(GetCoverageType request) {
        RequestUtils.checkService(request.getService());
        RequestUtils.checkVersion(request.getVersion());
        if (request.getCoverageId() == null || "".equals(request.getCoverageId())) {
            throw new OWS20Exception("Required parameter coverageId missing", (OWS20Exception.OWSExceptionCode)WCS20Exception.WCS20ExceptionCode.EmptyCoverageIdList, "coverageId");
        }
        return new GetCoverage(this.getServiceInfo(), this.catalog, this.envelopeAxesMapper, this.mimeMapper).run(request);
    }

    @Override
    public TransformerBase describeEOCoverageSet(DescribeEOCoverageSetType request) {
        throw new ServiceException("WCS-EO extension is not installed, thus the operation is not available");
    }
}

