/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.SourceWriter;
import it.geosolutions.jaiext.jiffle.parser.node.Statement;
import java.util.Objects;

public class While
implements Statement {
    private final Expression condition;
    private final Statement statement;

    public While(Expression condition, Statement statement) {
        this.condition = condition;
        this.statement = statement;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("while(_FN.isTrue(").append(this.condition).append(")) {\n").append(this.statement).append("}");
        return sb.toString();
    }

    @Override
    public void write(SourceWriter w) {
        w.indent().append("while (_FN.isTrue(");
        this.condition.write(w);
        w.append(")) {\n");
        w.inc();
        w.line("checkLoopIterations();");
        this.statement.write(w);
        w.dec();
        w.line("}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        While aWhile = (While)o;
        return Objects.equals(this.condition, aWhile.condition) && Objects.equals(this.statement, aWhile.statement);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.statement);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getStatement() {
        return this.statement;
    }
}

