/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser;

import it.geosolutions.jaiext.jiffle.parser.ConstantLookup;
import it.geosolutions.jaiext.jiffle.parser.Errors;
import it.geosolutions.jaiext.jiffle.parser.FunctionLookup;
import it.geosolutions.jaiext.jiffle.parser.JiffleParser;
import it.geosolutions.jaiext.jiffle.parser.JiffleType;
import it.geosolutions.jaiext.jiffle.parser.PropertyWorker;
import it.geosolutions.jaiext.jiffle.parser.Symbol;
import it.geosolutions.jaiext.jiffle.parser.SymbolScope;
import it.geosolutions.jaiext.jiffle.parser.TreeNodeProperties;
import it.geosolutions.jaiext.jiffle.parser.UndefinedFunctionException;
import it.geosolutions.jaiext.jiffle.parser.VarWorker;
import it.geosolutions.jaiext.jiffle.parser.node.ImageProperty;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionWorker
extends PropertyWorker<JiffleType> {
    private final TreeNodeProperties<SymbolScope> scopes;
    private final SymbolScope globalScope;

    public ExpressionWorker(ParseTree tree, VarWorker vw) {
        super(tree);
        this.scopes = vw.getProperties();
        this.globalScope = (SymbolScope)this.scopes.get(tree);
        this.walkTree();
    }

    public TreeNodeProperties<SymbolScope> getScopes() {
        return this.scopes;
    }

    @Override
    public void exitRange(JiffleParser.RangeContext ctx) {
        JiffleType left = this.get(ctx.expression(0));
        JiffleType right = this.get(ctx.expression(1));
        if (left != JiffleType.D || right != JiffleType.D) {
            this.messages.error(ctx.getStart(), Errors.LIST_IN_RANGE);
        }
        this.set((ParseTree)ctx, JiffleType.LIST);
    }

    @Override
    public void exitAtomExpr(JiffleParser.AtomExprContext ctx) {
        this.set((ParseTree)ctx, this.get((ParseTree)ctx.atom()));
    }

    @Override
    public void exitPowExpr(JiffleParser.PowExprContext ctx) {
        JiffleType arg = this.get(ctx.expression(0));
        JiffleType exponent = this.get(ctx.expression(1));
        if (exponent != JiffleType.D) {
            this.messages.error(ctx.getStart(), Errors.POW_EXPR_WITH_LIST_EXPONENT);
        }
        this.set((ParseTree)ctx, arg);
    }

    @Override
    public void exitPostExpr(JiffleParser.PostExprContext ctx) {
        this.set((ParseTree)ctx, this.get(ctx.expression()));
    }

    @Override
    public void exitPreExpr(JiffleParser.PreExprContext ctx) {
        this.set((ParseTree)ctx, this.get(ctx.expression()));
    }

    @Override
    public void exitNotExpr(JiffleParser.NotExprContext ctx) {
        this.set((ParseTree)ctx, this.get(ctx.expression()));
    }

    @Override
    public void exitTimesDivModExpr(JiffleParser.TimesDivModExprContext ctx) {
        this.setBinaryExprType((ParseTree)ctx, ctx.expression(0), ctx.expression(1));
    }

    @Override
    public void exitPlusMinusExpr(JiffleParser.PlusMinusExprContext ctx) {
        this.setBinaryExprType((ParseTree)ctx, ctx.expression(0), ctx.expression(1));
    }

    @Override
    public void exitCompareExpr(JiffleParser.CompareExprContext ctx) {
        this.setBinaryExprType((ParseTree)ctx, ctx.expression(0), ctx.expression(1));
    }

    @Override
    public void exitEqExpr(JiffleParser.EqExprContext ctx) {
        this.setBinaryExprType((ParseTree)ctx, ctx.expression(0), ctx.expression(1));
    }

    @Override
    public void exitAndExpr(JiffleParser.AndExprContext ctx) {
        this.setBinaryExprType((ParseTree)ctx, ctx.expression(0), ctx.expression(1));
    }

    @Override
    public void exitOrExpr(JiffleParser.OrExprContext ctx) {
        this.setBinaryExprType((ParseTree)ctx, ctx.expression(0), ctx.expression(1));
    }

    @Override
    public void exitXorExpr(JiffleParser.XorExprContext ctx) {
        this.setBinaryExprType((ParseTree)ctx, ctx.expression(0), ctx.expression(1));
    }

    @Override
    public void exitTernaryExpr(JiffleParser.TernaryExprContext ctx) {
        JiffleType condType = this.get(ctx.expression(0));
        if (condType != JiffleType.D) {
            this.messages.error(ctx.getStart(), Errors.LIST_AS_TERNARY_CONDITION);
        }
        this.setBinaryExprType((ParseTree)ctx, ctx.expression(1), ctx.expression(2));
    }

    @Override
    public void exitAssignExpr(JiffleParser.AssignExprContext ctx) {
        this.set((ParseTree)ctx, this.get((ParseTree)ctx.assignment()));
    }

    @Override
    public void exitImageProperty(JiffleParser.ImagePropertyContext ctx) {
        String property = ctx.ID(1).getText();
        ImageProperty.Property p = ImageProperty.lookupProperty(property);
        this.set((ParseTree)ctx, p.getType());
    }

    private void setBinaryExprType(ParseTree ctx, JiffleParser.ExpressionContext left, JiffleParser.ExpressionContext right) {
        JiffleType rightType;
        JiffleType leftType = this.get(left);
        if (leftType == (rightType = this.get(right))) {
            this.set(ctx, rightType);
        } else {
            this.set(ctx, JiffleType.LIST);
        }
    }

    protected JiffleType get(JiffleParser.ExpressionContext ctx) {
        JiffleParser.AtomExprContext atom;
        JiffleParser.IdentifiedAtomContext identifiedAtomContext;
        if (ctx instanceof JiffleParser.AtomExprContext && (identifiedAtomContext = (atom = (JiffleParser.AtomExprContext)ctx).atom().identifiedAtom()) instanceof JiffleParser.VarIDContext) {
            JiffleParser.VarIDContext var = (JiffleParser.VarIDContext)identifiedAtomContext;
            String varName = var.ID().getSymbol().getText();
            if (ConstantLookup.isDefined(varName)) {
                return JiffleType.D;
            }
            Symbol symbol = this.getScope((ParseTree)ctx).get(varName);
            if (symbol.getType() == null || symbol.getType() == Symbol.Type.UNKNOWN) {
                return JiffleType.UNKNOWN;
            }
            if (symbol.getType() == Symbol.Type.LIST) {
                return JiffleType.LIST;
            }
            return JiffleType.D;
        }
        return (JiffleType)((Object)super.get((ParseTree)ctx));
    }

    @Override
    public void exitAssignment(JiffleParser.AssignmentContext ctx) {
        JiffleType rhsType = this.get(ctx.expression());
        this.set((ParseTree)ctx, rhsType);
        String name = ctx.assignmentTarget().ID().getText();
        SymbolScope scope = this.getScope((ParseTree)ctx);
        Symbol symbol = scope.get(name);
        if (symbol.getType() == Symbol.Type.UNKNOWN) {
            Symbol.Type stype = this.getSymbolType(rhsType);
            scope.add(new Symbol(name, stype), true);
        } else {
            switch (symbol.getType()) {
                case SCALAR: 
                case DEST_IMAGE: {
                    if (rhsType != JiffleType.LIST) break;
                    this.messages.error(ctx.assignmentTarget().ID().getSymbol(), Errors.ASSIGNMENT_LIST_TO_SCALAR);
                    break;
                }
                case LIST: {
                    if (50 != ctx.op.getType()) {
                        this.messages.error(ctx.assignmentTarget().ID().getSymbol(), Errors.INVALID_OPERATION_FOR_LIST);
                        break;
                    }
                    if (rhsType != JiffleType.D) break;
                    this.messages.error(ctx.assignmentTarget().ID().getSymbol(), Errors.ASSIGNMENT_SCALAR_TO_LIST);
                }
            }
        }
    }

    @Override
    public void exitVarDeclaration(JiffleParser.VarDeclarationContext ctx) {
        JiffleType rhsType = this.get(ctx.expression());
        this.set((ParseTree)ctx, rhsType);
        String name = ctx.ID().getText();
        SymbolScope scope = this.getScope((ParseTree)ctx);
        Symbol symbol = scope.get(name);
        if (symbol.getType() == Symbol.Type.UNKNOWN) {
            Symbol.Type stype = this.getSymbolType(rhsType);
            scope.add(new Symbol(name, stype), true);
        } else {
            switch (symbol.getType()) {
                case SCALAR: 
                case DEST_IMAGE: {
                    if (rhsType != JiffleType.LIST) break;
                    this.messages.error(ctx.ID().getSymbol(), Errors.ASSIGNMENT_LIST_TO_SCALAR);
                    break;
                }
                case LIST: {
                    if (rhsType != JiffleType.D) break;
                    this.messages.error(ctx.ID().getSymbol(), Errors.ASSIGNMENT_SCALAR_TO_LIST);
                }
            }
        }
    }

    private Symbol.Type getSymbolType(JiffleType type) {
        if (type == null || type == JiffleType.UNKNOWN) {
            return Symbol.Type.UNKNOWN;
        }
        if (type == JiffleType.D) {
            return Symbol.Type.SCALAR;
        }
        if (type == JiffleType.LIST) {
            return Symbol.Type.LIST;
        }
        throw new IllegalArgumentException("Symbol type unknown: " + (Object)((Object)type));
    }

    @Override
    public void exitAtom(JiffleParser.AtomContext ctx) {
        this.set((ParseTree)ctx, this.get(ctx.getChild(0)));
    }

    @Override
    public void exitParenExpression(JiffleParser.ParenExpressionContext ctx) {
        this.set((ParseTree)ctx, this.get(ctx.expression()));
    }

    @Override
    public void exitConCall(JiffleParser.ConCallContext ctx) {
        this.set((ParseTree)ctx, JiffleType.D);
    }

    @Override
    public void exitVarID(JiffleParser.VarIDContext ctx) {
        String name = ctx.ID().getText();
        if (ConstantLookup.isDefined(name)) {
            this.set((ParseTree)ctx, JiffleType.D);
        } else {
            SymbolScope scope = this.getScope((ParseTree)ctx);
            Symbol symbol = scope.get(name);
            switch (symbol.getType()) {
                case LIST: {
                    this.set((ParseTree)ctx, JiffleType.LIST);
                    break;
                }
                default: {
                    this.set((ParseTree)ctx, JiffleType.UNKNOWN);
                }
            }
            Symbol.Type type = scope.get(name).getType();
            if (type == Symbol.Type.UNKNOWN) {
                this.messages.error(ctx.ID().getSymbol(), (Object)((Object)Errors.UNINIT_VAR) + ": " + name);
            }
        }
    }

    @Override
    public void exitImageCall(JiffleParser.ImageCallContext ctx) {
        String name = ctx.ID().getSymbol().getText();
        Symbol symbol = this.globalScope.get(name);
        if (symbol == null || symbol.getType() == Symbol.Type.UNKNOWN) {
            this.messages.error(ctx.ID().getSymbol(), (Object)((Object)Errors.UNDEFINED_SOURCE) + ": " + name);
        } else if (symbol.getType() == Symbol.Type.SCALAR || symbol.getType() == Symbol.Type.LIST) {
            this.messages.error(ctx.ID().getSymbol(), (Object)((Object)Errors.IMAGE_POS_ON_NON_IMAGE) + ": " + name);
        }
        this.set((ParseTree)ctx, JiffleType.D);
    }

    @Override
    public void exitFunctionCall(JiffleParser.FunctionCallContext ctx) {
        String name = ctx.ID().getText();
        try {
            JiffleParser.ExpressionListContext expressionList = ctx.argumentList().expressionList();
            ArrayList<JiffleType> argumentTypes = new ArrayList<JiffleType>();
            if (expressionList != null) {
                List<JiffleParser.ExpressionContext> expressions = expressionList.expression();
                for (JiffleParser.ExpressionContext expression : expressions) {
                    JiffleType type = this.get(expression);
                    argumentTypes.add(type);
                }
            }
            JiffleType[] array = argumentTypes.toArray(new JiffleType[argumentTypes.size()]);
            this.set((ParseTree)ctx, FunctionLookup.getInfo(name, array).getReturnType());
        }
        catch (UndefinedFunctionException ex) {
            this.messages.error(ctx.ID().getSymbol(), ex.getMessage());
        }
    }

    @Override
    public void exitLiteral(JiffleParser.LiteralContext ctx) {
        this.set((ParseTree)ctx, JiffleType.D);
    }

    @Override
    public void exitListLiteral(JiffleParser.ListLiteralContext ctx) {
        this.set((ParseTree)ctx, JiffleType.LIST);
    }

    private SymbolScope getScope(ParseTree ctx) {
        if (ctx != null) {
            SymbolScope s = (SymbolScope)this.scopes.get(ctx);
            return s != null ? s : this.getScope(ctx.getParent());
        }
        throw new IllegalStateException("Compiler error: failed to find symbol scope");
    }
}

