/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Stroke;
import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.StrokeBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.brewer.styling.builder.SymbolizerBuilder;
import org.geotools.styling.StrokeImpl;

public class LineSymbolizerBuilder
extends SymbolizerBuilder<LineSymbolizer> {
    StrokeBuilder strokeBuilder = new StrokeBuilder(this);
    Expression geometry = null;
    Unit<Length> uom = null;
    Expression perpendicularOffset;

    public LineSymbolizerBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    LineSymbolizerBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public LineSymbolizerBuilder geometry(Expression geometry) {
        this.geometry = geometry;
        return this;
    }

    public LineSymbolizerBuilder geometry(String cqlExpression) {
        return this.geometry(this.cqlExpression(cqlExpression));
    }

    public StrokeBuilder stroke() {
        this.unset = false;
        return this.strokeBuilder;
    }

    public LineSymbolizerBuilder uom(Unit<Length> uom) {
        this.unset = false;
        this.uom = uom;
        return this;
    }

    @Override
    public LineSymbolizer build() {
        if (this.unset) {
            return null;
        }
        Stroke stroke = this.strokeBuilder.build();
        if (stroke == null) {
            stroke = StrokeImpl.DEFAULT;
        }
        LineSymbolizer ls = this.sf.createLineSymbolizer(stroke, null);
        if (this.geometry != null) {
            ls.setGeometry(this.geometry);
        }
        if (this.uom != null) {
            ls.setUnitOfMeasure(this.uom);
        }
        if (this.perpendicularOffset != null) {
            ls.setPerpendicularOffset(this.perpendicularOffset);
        }
        ls.getOptions().putAll(this.options);
        if (this.parent == null) {
            this.reset();
        }
        return ls;
    }

    public LineSymbolizerBuilder reset() {
        this.strokeBuilder.reset();
        this.geometry = null;
        this.unset = false;
        this.uom = null;
        this.perpendicularOffset = null;
        return this;
    }

    public LineSymbolizerBuilder reset(LineSymbolizer original) {
        if (original == null) {
            return this.unset();
        }
        this.geometry = this.property(original.getGeometryPropertyName());
        this.strokeBuilder.reset(original.getStroke());
        this.uom = original.getUnitOfMeasure();
        this.perpendicularOffset = original.getPerpendicularOffset();
        return this;
    }

    @Override
    public LineSymbolizerBuilder unset() {
        return (LineSymbolizerBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().line().init(this);
    }

    public LineSymbolizerBuilder perpendicularOffset(Expression perpendicularOffset) {
        this.perpendicularOffset = perpendicularOffset;
        return this;
    }

    public LineSymbolizerBuilder perpendicularOffset(double perpendicularOffset) {
        this.perpendicularOffset = this.literal(perpendicularOffset);
        return this;
    }
}

