/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.Request;
import org.geoserver.ows.kvp.ViewParamsFormatParser;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ViewParamsKvpParser
extends KvpParser
implements ApplicationContextAware {
    private static final Logger LOGGER = Logging.getLogger(ViewParamsKvpParser.class);
    private static final String VIEW_PARAMS_FORMAT_PARAMETER_NAME = "viewParamsFormat";
    ApplicationContext applicationContext;

    public ViewParamsKvpParser() {
        super("viewparams", List.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Object parse(String value) throws Exception {
        ViewParamsFormatParser formatParser = this.getRequestFormatParser();
        LOGGER.log(Level.FINE, "Using selected format parser: {0}", formatParser);
        return formatParser.parse(value);
    }

    private ViewParamsFormatParser getRequestFormatParser() {
        List formatParsers = GeoServerExtensions.extensions(ViewParamsFormatParser.class, (ApplicationContext)this.applicationContext);
        String formatParserParameterValue = this.getFormatParserParameterValue();
        LOGGER.log(Level.FINE, "Using format parser identifier: {0}", formatParserParameterValue);
        return formatParsers.stream().filter(fp -> fp.getIdentifier().equals(formatParserParameterValue)).findFirst().orElseThrow(() -> new ServiceException("Selected viewParamsFormat is not available as implementation on GeoServer. viewParamsFormat value is '" + this.getRequestFormatParserParameterValue() + "'", "InvalidParameterValue", VIEW_PARAMS_FORMAT_PARAMETER_NAME));
    }

    private String getFormatParserParameterValue() {
        String formatParserParameterValue = this.getRequestFormatParserParameterValue();
        if (StringUtils.isBlank((CharSequence)formatParserParameterValue)) {
            formatParserParameterValue = "CharSeparated";
        }
        return formatParserParameterValue;
    }

    private String getRequestFormatParserParameterValue() {
        Request request = Dispatcher.REQUEST.get();
        if (request == null || request.getRawKvp() == null) {
            return this.getSerlvetRequestFormatParserParameterValue();
        }
        Map<String, Object> rawKvp = request.getRawKvp();
        if (this.mapContainsKey(VIEW_PARAMS_FORMAT_PARAMETER_NAME, rawKvp)) {
            return (String)this.mapGet(VIEW_PARAMS_FORMAT_PARAMETER_NAME, rawKvp);
        }
        return this.getSerlvetRequestFormatParserParameterValue();
    }

    private String getSerlvetRequestFormatParserParameterValue() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes == null || servletRequestAttributes.getRequest() == null || servletRequestAttributes.getRequest().getParameterMap() == null) {
            return null;
        }
        HttpServletRequest request = servletRequestAttributes.getRequest();
        Map parameterMap = request.getParameterMap();
        if (this.mapContainsKey(VIEW_PARAMS_FORMAT_PARAMETER_NAME, parameterMap)) {
            String[] strings = (String[])this.mapGet(VIEW_PARAMS_FORMAT_PARAMETER_NAME, parameterMap);
            return this.getFirstExisting(strings);
        }
        return null;
    }

    private boolean mapContainsKey(String key, Map<String, ?> map) {
        return map.keySet().stream().anyMatch(k -> k.trim().toLowerCase().equals(key.trim().toLowerCase()));
    }

    private <T> T mapGet(String key, Map<String, T> map) {
        return map.entrySet().stream().filter(e -> ((String)e.getKey()).trim().toLowerCase().equals(key.trim().toLowerCase())).map(e -> e.getValue()).findFirst().orElse(null);
    }

    private String getFirstExisting(String[] strArray) {
        if (strArray == null) {
            return null;
        }
        for (String value : strArray) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return value;
        }
        return null;
    }
}

