/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;

public class ElevationParser {
    static final Logger LOGGER = Logging.getLogger(ElevationParser.class);
    private static final int DEFAULT_MAX_ELEMENTS_ELEVATIONS_KVP = 100;
    private final Integer maxElevations;

    public ElevationParser() {
        this.maxElevations = null;
    }

    public ElevationParser(int maxElevations) {
        this.maxElevations = maxElevations;
    }

    public Collection parse(String value) throws ParseException {
        if (value == null) {
            return Collections.emptyList();
        }
        if ((value = value.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<Object> values = new TreeSet<Object>((o1, o2) -> {
            boolean o1Double = o1 instanceof Double;
            boolean o2Double = o2 instanceof Double;
            if (o1Double) {
                Double left = (Double)o1;
                if (o2Double) {
                    return left.compareTo((Double)o2);
                }
                return left.compareTo((Double)((NumberRange)o2).getMinValue());
            }
            NumberRange left = (NumberRange)o1;
            if (o2Double) {
                return left.getMinValue().compareTo(o2);
            }
            return left.getMinValue().compareTo(((NumberRange)o2).getMinValue());
        });
        String[] listValues = value.split(",");
        int maxValues = this.getMaxElevations();
        for (String d : listValues) {
            if (d.indexOf("/") <= 0) {
                this.addValue(values, Double.valueOf(d.trim()));
            } else {
                Double end;
                Double begin;
                Object[] period = d.split("/");
                if (period.length == 2) {
                    begin = Double.valueOf(period[0]);
                    end = Double.valueOf(period[1]);
                    this.addPeriod(values, (NumberRange<Double>)NumberRange.create((double)begin, (double)end));
                } else if (period.length == 3) {
                    begin = Double.valueOf(period[0]);
                    end = Double.valueOf((String)period[1]);
                    Double increment = Double.valueOf((String)period[2]);
                    int j = 0;
                    while (true) {
                        Double d2;
                        Double step = (double)j * increment + begin;
                        if (d2 <= end) {
                            if (!this.addValue(values, step) && j >= maxValues) {
                                throw new ServiceException("Exceeded " + maxValues + " iterations parsing elevations, bailing out.", "InvalidParameterValue", "elevation");
                            }
                            ++j;
                            this.checkMaxElevations(values, maxValues);
                            continue;
                        }
                        break;
                    }
                } else {
                    throw new ParseException("Invalid elevation parameter: " + Arrays.toString(period), 0);
                }
            }
            this.checkMaxElevations(values, maxValues);
        }
        return new ArrayList(values);
    }

    private int getMaxElevations() {
        if (this.maxElevations != null) {
            return this.maxElevations;
        }
        return 100;
    }

    public void checkMaxElevations(Set result, int maxValues) {
        if (maxValues > 0 && result.size() > maxValues) {
            throw new ServiceException("More than " + maxValues + " elevations specified in the request, bailing out.", "InvalidParameterValue", "elevation");
        }
    }

    private boolean addValue(Collection<Double> result, Double step) {
        for (Double element : result) {
            Double local;
            if (!(element instanceof Double ? (local = element).equals(step) : (local = (NumberRange)element).contains(step))) continue;
            return false;
        }
        return result.add(step);
    }

    private void addPeriod(Collection<Object> result, NumberRange<Double> newRange) {
        Iterator<Object> it = result.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof Double) {
                if (!newRange.contains((Number)element)) continue;
                it.remove();
                continue;
            }
            NumberRange local = (NumberRange)element;
            if (local.contains(newRange)) {
                return;
            }
            if (!newRange.contains((Range)local)) continue;
            it.remove();
        }
        result.add(newRange);
    }
}

