/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.xml.sax.SAXException;

public abstract class XmlRequestReader {
    final Logger LOGGER;
    final QName element;
    final Version version;
    final String serviceId;

    public XmlRequestReader(QName element) {
        this(element, null, null);
    }

    public XmlRequestReader(String namespace, String local) {
        this(new QName(namespace, local));
    }

    public XmlRequestReader(QName element, Version version, String serviceId) {
        this.element = element;
        this.version = version;
        this.serviceId = serviceId;
        this.LOGGER = Logging.getLogger(this.getClass());
        if (element == null) {
            throw new NullPointerException("element");
        }
    }

    public QName getElement() {
        return this.element;
    }

    public Version getVersion() {
        return this.version;
    }

    public abstract Object read(Object var1, Reader var2, Map var3) throws Exception;

    public boolean equals(Object obj) {
        if (!(obj instanceof XmlRequestReader)) {
            return false;
        }
        XmlRequestReader other = (XmlRequestReader)obj;
        return new EqualsBuilder().append((Object)this.element, (Object)other.element).append((Object)this.version, (Object)other.version).append((Object)this.serviceId, (Object)other.serviceId).isEquals();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.element + ", " + this.serviceId + ", " + this.version + ")";
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.element).append((Object)this.version).append((Object)this.serviceId).toHashCode();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    protected Exception cleanException(Exception t) {
        if (t instanceof IOException) {
            return this.createParseException(t);
        }
        if (t instanceof SAXException) {
            return this.cleanSaxException((SAXException)t);
        }
        return t;
    }

    protected SAXException cleanSaxException(SAXException saxException) {
        Throwable cause = saxException.getCause();
        if (saxException != null && saxException.getCause() != null && saxException.getClass() == SAXException.class) {
            String saxMessage = saxException.getMessage();
            String causeMessage = cause.getLocalizedMessage();
            if (causeMessage != null && saxMessage.contains(causeMessage)) {
                return this.createParseException(saxException);
            }
        }
        return saxException;
    }

    protected SAXException createParseException(Throwable cause) {
        String requestFailure = "XML " + this.getElement().getLocalPart() + " Parsing Failure: ";
        this.LOGGER.info(requestFailure + cause.toString());
        String cleanMessage = "Parsing failed, the xml request is most probably not compliant to " + this.getElement().getLocalPart() + " element";
        SAXException saxException = new SAXException(cleanMessage);
        saxException.setStackTrace(cause.getStackTrace());
        return saxException;
    }
}

