/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.util.EncodingInfo;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.geotools.util.URLs;
import org.springframework.http.ContentDisposition;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class AbstractURLPublisher
extends AbstractController {
    protected boolean replaceWindowsFileSeparator = false;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long lastModified;
        String reqPath = this.getRequestPath(request);
        URL url = this.getUrl(request, reqPath);
        if (url == null) {
            response.sendError(404);
            return null;
        }
        File file = URLs.urlToFile((URL)url);
        if (file != null && file.exists() && file.isDirectory()) {
            Object uri;
            uri = (String)uri + (((String)(uri = request.getRequestURI())).endsWith("/") ? "index.html" : "/index.html");
            response.addHeader("Location", (String)uri);
            response.sendError(302);
            return null;
        }
        if (file != null && this.checkNotModified(request, file.lastModified())) {
            response.setStatus(304);
            return null;
        }
        String filename = new File(url.getFile()).getName();
        String mime = this.getMimeType(reqPath, filename);
        response.setContentType(mime);
        String dispositionType = this.isAttachment(reqPath, filename, mime) ? "attachment" : "inline";
        response.setHeader("Content-Disposition", ContentDisposition.builder((String)dispositionType).filename(filename).build().toString());
        URLConnection connection = url.openConnection();
        long length = connection.getContentLength();
        if (length > 0L && length <= Integer.MAX_VALUE) {
            response.setContentLength((int)length);
        }
        if ((lastModified = connection.getLastModified()) > 0L) {
            response.setHeader("Last-Modified", AbstractURLPublisher.lastModified(lastModified));
        }
        EncodingInfo encInfo = null;
        byte[] b4 = new byte[4];
        int count = 0;
        try (InputStream input = connection.getInputStream();){
            count = input.read(b4);
            encInfo = XmlCharsetDetector.getEncodingName(b4, count);
            response.setCharacterEncoding(encInfo.getEncoding() != null ? encInfo.getEncoding() : "UTF-8");
            if (count > 0) {
                ServletOutputStream output = response.getOutputStream();
                output.write(b4, 0, count);
                byte[] buffer = new byte[8192];
                int n = -1;
                while ((n = input.read(buffer)) != -1) {
                    output.write(buffer, 0, n);
                }
            }
        }
        return null;
    }

    private boolean checkNotModified(HttpServletRequest request, long timeStamp) {
        String header;
        Enumeration headers = request.getHeaders("If-Modified-Since");
        String string = header = headers != null && headers.hasMoreElements() ? headers.nextElement().toString() : null;
        if (header != null && !header.isEmpty()) {
            long timeStampSeconds;
            long ifModSinceSeconds = AbstractURLPublisher.lastModified(header);
            return ifModSinceSeconds >= (timeStampSeconds = 1000L * (timeStamp / 1000L));
        }
        return false;
    }

    private String getRequestPath(HttpServletRequest request) throws IOException {
        String reqPath = URLDecoder.decode(request.getRequestURI(), "UTF-8").substring(request.getContextPath().length());
        if (this.replaceWindowsFileSeparator) {
            reqPath = reqPath.replace(File.separatorChar, '/');
        }
        if (Arrays.stream(reqPath.split("/")).anyMatch(".."::equals)) {
            throw new IllegalArgumentException("Contains invalid '..' path: " + reqPath);
        }
        return reqPath;
    }

    static String lastModified(long timeStamp) {
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(new Date(timeStamp)) + " GMT";
    }

    static long lastModified(String timeStamp) {
        long ifModifiedSince = Long.MIN_VALUE;
        try {
            SimpleDateFormat fmt = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
            fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            ifModifiedSince = fmt.parse(timeStamp).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return 1000L * (ifModifiedSince / 1000L);
    }

    protected String getMimeType(String reqPath, String filename) {
        return Optional.ofNullable(this.getServletContext()).map(sc -> sc.getMimeType(filename)).orElse("application/octet-stream");
    }

    protected boolean isAttachment(String reqPath, String filename, String mime) {
        return false;
    }

    protected abstract URL getUrl(HttpServletRequest var1, String var2) throws IOException;
}

