/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.wicket.SimpleAjaxLink;

public abstract class ConfirmationAjaxLink<T>
extends SimpleAjaxLink<T> {
    IModel<String> confirm;

    public ConfirmationAjaxLink(String id, IModel<T> linkModel, String label, String confirm) {
        this(id, linkModel, (IModel<String>)new Model((Serializable)((Object)label)), (IModel<String>)new Model((Serializable)((Object)confirm)));
    }

    public ConfirmationAjaxLink(String id, IModel<T> linkModel, IModel<String> labelModel, IModel<String> confirm) {
        super(id, linkModel, labelModel);
        this.confirm = confirm;
    }

    @Override
    protected AjaxLink<T> buildAjaxLink(IModel<T> linkModel) {
        return new AjaxLink<T>("link", linkModel){

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(new AjaxCallListener(){

                    public CharSequence getPrecondition(Component component) {
                        CharSequence message = JavaScriptUtils.escapeQuotes((CharSequence)((CharSequence)ConfirmationAjaxLink.this.confirm.getObject()));
                        return "if(!confirm('" + message + "')) return false;";
                    }
                });
            }

            public void onClick(AjaxRequestTarget target) {
                ConfirmationAjaxLink.this.onClick(target);
            }
        };
    }
}

