/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.util.List;
import java.util.Set;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.web.publish.CommonPublishedEditTabPanelInfo;
import org.geoserver.web.security.AccessDataRuleInfoManager;
import org.geoserver.web.security.DataAccessRuleInfo;

public class LayerAccessDataRulePanelInfo
extends CommonPublishedEditTabPanelInfo {
    private static final long serialVersionUID = -2621468069548681109L;

    @Override
    public ListModel<DataAccessRuleInfo> createOwnModel(IModel<? extends PublishedInfo> layerModel, boolean isNew) {
        CatalogInfo info = (CatalogInfo)layerModel.getObject();
        AccessDataRuleInfoManager manager = new AccessDataRuleInfoManager();
        String workspaceName = manager.getWorkspaceName(info);
        String layerName = manager.getLayerName(info);
        Set<String> authorities = manager.getAvailableRoles();
        Set<DataAccessRule> rules = manager.getResourceRule(workspaceName, info);
        List<DataAccessRuleInfo> modelRules = manager.mapTo(rules, authorities, workspaceName, layerName);
        return new ListModel(modelRules);
    }

    @Override
    public boolean supports(PublishedInfo pi) {
        return this.getPublishedInfoClass().isAssignableFrom(pi.getClass()) && AccessDataRuleInfoManager.canAccess();
    }
}

