/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;

public class StoreNameValidator
implements IFormValidator {
    FormComponent workspaceComponent;
    FormComponent storeNameComponent;
    private String edittingStoreId;
    private boolean required;

    public StoreNameValidator(FormComponent workspaceFormComponent, FormComponent storeNameFormComponent, String edittingStoreId) {
        this(workspaceFormComponent, storeNameFormComponent, edittingStoreId, true);
    }

    public StoreNameValidator(FormComponent workspaceFormComponent, FormComponent storeNameFormComponent, String edittingStoreId, boolean required) {
        this.workspaceComponent = workspaceFormComponent;
        this.storeNameComponent = storeNameFormComponent;
        this.edittingStoreId = edittingStoreId;
        this.required = required;
    }

    public FormComponent[] getDependentFormComponents() {
        return new FormComponent[]{this.workspaceComponent, this.storeNameComponent};
    }

    public void validate(Form form) {
        String existingId;
        FormComponent[] components = this.getDependentFormComponents();
        FormComponent wsComponent = components[0];
        FormComponent nameComponent = components[1];
        WorkspaceInfo workspace = (WorkspaceInfo)wsComponent.getConvertedInput();
        String name = (String)nameComponent.getConvertedInput();
        if (name == null) {
            if (this.required) {
                nameComponent.error((IValidationError)new ValidationError("StoreNameValidator.storeNameRequired").addKey("StoreNameValidator.storeNameRequired"));
            }
            return;
        }
        Catalog catalog = GeoServerApplication.get().getCatalog();
        StoreInfo existing = catalog.getStoreByName(workspace, name, StoreInfo.class);
        if (existing != null && !(existingId = existing.getId()).equals(this.edittingStoreId)) {
            ValidationError error = new ValidationError("StoreNameValidator.storeExistsInWorkspace").addKey("StoreNameValidator.storeExistsInWorkspace").setVariable("workspace", (Object)workspace.getName()).setVariable("storeName", (Object)name);
            nameComponent.error((IValidationError)error);
        }
    }
}

