/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.catalog.util.FeatureTypeDimensionsAccessor;
import org.geoserver.web.data.resource.VectorCustomDimensionEditor;
import org.geoserver.web.data.resource.VectorCustomDimensionEntry;
import org.geoserver.web.util.MetadataMapModel;

public class VectorCustomDimensionsPanel
extends Panel {
    private final IModel<FeatureTypeInfo> typeInfoModel;
    private final IModel<MetadataMap> metadata;
    private final WebMarkupContainer mainDiv;

    public VectorCustomDimensionsPanel(String id, IModel<FeatureTypeInfo> typeInfoModel) {
        super(id, typeInfoModel);
        this.typeInfoModel = typeInfoModel;
        this.metadata = new PropertyModel(typeInfoModel, "metadata");
        this.setOutputMarkupId(true);
        this.mainDiv = new WebMarkupContainer("mainDiv");
        this.mainDiv.setOutputMarkupId(true);
        this.add(new Component[]{this.mainDiv});
        Form addForm = new Form("form");
        addForm.setOutputMarkupId(true);
        this.mainDiv.add(new Component[]{addForm});
        WebMarkupContainer addDimContainer = new WebMarkupContainer("addVectorCustomDimensionPanel");
        addDimContainer.setOutputMarkupId(true);
        addForm.add(new Component[]{addDimContainer});
        FeedbackPanel feedback = new FeedbackPanel("feedback");
        addDimContainer.add(new Component[]{feedback});
        final TextField nameInput = new TextField("nameInput", (IModel)new Model((Serializable)((Object)"")));
        addDimContainer.add(new Component[]{nameInput});
        AjaxButton addButton = new AjaxButton("addButton", addForm){

            protected void onAfterSubmit(AjaxRequestTarget target) {
                nameInput.processInput();
                String newName = (String)nameInput.getModelObject();
                nameInput.getModel().setObject((Object)"");
                VectorCustomDimensionsPanel.this.addNewDimension(newName);
                target.add(new Component[]{VectorCustomDimensionsPanel.this.mainDiv});
            }
        };
        addButton.setDefaultFormProcessing(false);
        addDimContainer.add(new Component[]{addButton});
        RefreshingView<VectorCustomDimensionEntry> refreshingView = this.buildVectorCustomDimensionsView(typeInfoModel);
        refreshingView.setOutputMarkupId(true);
        addForm.add(new Component[]{refreshingView});
    }

    private void addNewDimension(String name) {
        if (StringUtils.isBlank((CharSequence)name) || !this.validateNewCustomDimensionName(name)) {
            return;
        }
        name = this.foldDimentionMapKey(name);
        MetadataMap metadataMap = (MetadataMap)this.getMetadata().getObject();
        if (!metadataMap.containsKey((Object)name)) {
            DimensionInfoImpl dimInfo = new DimensionInfoImpl();
            dimInfo.setEnabled(true);
            metadataMap.put(name, (Serializable)dimInfo);
        }
    }

    private boolean validateNewCustomDimensionName(String name) {
        if ("time".equals(name = name.toLowerCase().trim()) || "elevation".equals(name)) {
            this.error((Serializable)((Object)("'" + name + "' not allowed for custom dimension name.")));
            return false;
        }
        String dimName = this.foldDimentionMapKey(name);
        MetadataMap metadataMap = (MetadataMap)this.getMetadata().getObject();
        if (metadataMap.containsKey((Object)dimName)) {
            this.error((Serializable)((Object)("'" + name + "' custom dimension already exists.")));
            return false;
        }
        return true;
    }

    private String foldDimentionMapKey(String name) {
        return "dim_" + name.toLowerCase();
    }

    public IModel<FeatureTypeInfo> getTypeInfoModel() {
        return this.typeInfoModel;
    }

    public IModel<MetadataMap> getMetadata() {
        return this.metadata;
    }

    private List<IModel<VectorCustomDimensionEntry>> getCustomDimensionMetadataList(IModel<FeatureTypeInfo> typeInfoModel) {
        PropertyModel metadata = new PropertyModel(this.getTypeInfoModel(), "metadata");
        ArrayList<IModel<VectorCustomDimensionEntry>> models = new ArrayList<IModel<VectorCustomDimensionEntry>>();
        FeatureTypeInfo typeInfo = (FeatureTypeInfo)typeInfoModel.getObject();
        FeatureTypeDimensionsAccessor accessor = new FeatureTypeDimensionsAccessor(typeInfo);
        Map customDimensions = accessor.getCustomDimensions();
        for (Map.Entry dimension : customDimensions.entrySet()) {
            String dimensionName = (String)dimension.getKey();
            models.add(new VectorDimensionModel((IModel<MetadataMap>)metadata, dimensionName, DimensionInfo.class));
        }
        return models;
    }

    private RefreshingView<VectorCustomDimensionEntry> buildVectorCustomDimensionsView(final IModel<FeatureTypeInfo> typeInfoModel) {
        RefreshingView<VectorCustomDimensionEntry> view = new RefreshingView<VectorCustomDimensionEntry>("vectorCustomDimensionsView"){

            protected Iterator<IModel<VectorCustomDimensionEntry>> getItemModels() {
                return VectorCustomDimensionsPanel.this.getCustomDimensionMetadataList((IModel<FeatureTypeInfo>)typeInfoModel).iterator();
            }

            protected void populateItem(Item<VectorCustomDimensionEntry> item) {
                VectorCustomDimensionEntry entry = (VectorCustomDimensionEntry)item.getModel().getObject();
                WebMarkupContainer div = new WebMarkupContainer("vectorCustomDimension");
                div.setOutputMarkupId(true);
                item.add(new Component[]{div});
                div.add(new Component[]{new Label("dimensionName", (Serializable)((Object)entry.getKeyNoPrefixed()))});
                VectorCustomDimensionEditor editor = new VectorCustomDimensionEditor("customVectorEditor", (IModel<VectorCustomDimensionEntry>)item.getModel(), (ResourceInfo)typeInfoModel.getObject(), (Class<?>)Serializable.class);
                editor.disablePresentationMode(DimensionPresentation.CONTINUOUS_INTERVAL);
                div.add(new Component[]{editor});
            }
        };
        view.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        return view;
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof VectorCustomDimensionEditor.RemoveEvent) {
            VectorCustomDimensionEditor.RemoveEvent removeEvent = (VectorCustomDimensionEditor.RemoveEvent)event.getPayload();
            this.removeDimensionByKey(removeEvent.getEntry().getFormerKey());
            removeEvent.getTarget().add(new Component[]{this.mainDiv});
        }
    }

    private void removeDimensionByKey(String key) {
        ((MetadataMap)this.metadata.getObject()).remove((Object)key);
    }

    public static class VectorDimensionModel
    extends MetadataMapModel<VectorCustomDimensionEntry> {
        private static final String VECTOR_CUSTOM_DIMENSION_PREFIX = "dim_";
        boolean hasRange;
        boolean hasResolution;
        private String key;
        private VectorCustomDimensionEntry entry;

        public VectorDimensionModel(IModel<MetadataMap> model, String expression, Class<?> target) {
            super(model, expression, target);
            this.key = VECTOR_CUSTOM_DIMENSION_PREFIX + expression;
        }

        @Override
        public VectorCustomDimensionEntry getObject() {
            DimensionInfo dim = (DimensionInfo)((MetadataMap)this.model.getObject()).get(VECTOR_CUSTOM_DIMENSION_PREFIX + this.expression, this.target);
            if (this.entry == null) {
                Pair pair = Pair.of((Object)this.key, (Object)dim);
                this.entry = new VectorCustomDimensionEntry((Map.Entry<String, DimensionInfo>)pair);
            } else {
                this.entry.setDimensionInfo(dim);
            }
            return this.entry;
        }

        @Override
        public void setObject(VectorCustomDimensionEntry object) {
            if (object.hasModifiedKey()) {
                ((MetadataMap)this.model.getObject()).remove((Object)object.getFormerKey());
            }
            ((MetadataMap)this.model.getObject()).put(object.getKey(), (Serializable)object.getDimensionInfo());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VectorDimensionModel other = (VectorDimensionModel)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

