/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.web.GeoServerApplication;
import org.geotools.api.filter.Filter;

public class PublishedInfosModel
extends LoadableDetachableModel<List<PublishedInfo>> {
    protected Filter getFilter() {
        return Predicates.acceptAll();
    }

    protected List<PublishedInfo> load() {
        Catalog catalog = GeoServerApplication.get().getCatalog();
        ArrayList<PublishedInfo> layers = new ArrayList<PublishedInfo>();
        try (CloseableIterator iterator = catalog.list(PublishedInfo.class, this.getFilter());){
            iterator.forEachRemaining(layers::add);
        }
        Collections.sort(layers, Comparator.comparing(PublishedInfo::prefixedName));
        return layers;
    }
}

