/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs20.ParameterExpressionType;
import net.opengis.wfs20.StoredQueryListItemType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.data.layer.CascadedWFSStoredQueryAbstractPage;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.data.DataAccess;
import org.geotools.api.feature.type.Name;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.internal.v2_0.storedquery.StoredQueryConfiguration;
import org.geotools.util.logging.Logging;

public class CascadedWFSStoredQueryNewPage
extends CascadedWFSStoredQueryAbstractPage {
    private static final long serialVersionUID = 5430480206314316146L;
    static final Logger LOGGER = Logging.getLogger(CascadedWFSStoredQueryNewPage.class);
    DropDownChoice<StoredQuery> storedQueriesDropDown;
    private String nativeName;

    public CascadedWFSStoredQueryNewPage(PageParameters params) throws IOException {
        super(params);
    }

    @Override
    protected Component getStoredQueryNameComponent() {
        Fragment f = new Fragment("storedQueryName", "newPage", (MarkupContainer)this);
        this.storedQueriesDropDown = this.storedQueriesDropDown();
        f.add(new Component[]{this.storedQueriesDropDown});
        TextField textField = new TextField("nativeName", (IModel)new PropertyModel((Object)this, "nativeName"));
        textField.setRequired(true);
        textField.add((IValidator)new ViewNameValidator());
        f.add(new Component[]{textField});
        return f;
    }

    public void setNativeName(String nativeName) {
        this.nativeName = nativeName;
    }

    public String getNativeName() {
        return this.nativeName;
    }

    @Override
    public void populateStoredQueryParameterAttribute(String storedQueryId, ParameterExpressionType pet, CascadedWFSStoredQueryAbstractPage.StoredQueryParameterAttribute attr) {
        attr.setMappingType(CascadedWFSStoredQueryAbstractPage.ParameterMappingType.NONE);
        attr.setValue(null);
    }

    @Override
    protected void onSave() {
        StoredQuery selection = (StoredQuery)this.storedQueriesDropDown.getDefaultModelObject();
        StoredQueryConfiguration config = CascadedWFSStoredQueryNewPage.createStoredQueryConfiguration(this.parameterProvider.getItems(), selection.storedQueryId);
        try {
            DataStoreInfo dsInfo = (DataStoreInfo)this.getCatalog().getStore(this.storeId, DataStoreInfo.class);
            WFSDataStore directDs = this.getContentDataStore();
            DataAccess da = dsInfo.getDataStore(null);
            Name typeName = directDs.addStoredQuery(this.getNativeName(), config.getStoredQueryId());
            CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
            builder.setStore((StoreInfo)dsInfo);
            FeatureTypeInfo fti = builder.buildFeatureType(da.getFeatureSource(typeName));
            fti.getMetadata().put("WFS_NG_STORED_QUERY_CONFIGURATION", (Serializable)config);
            LayerInfo layerInfo = builder.buildLayer(fti);
            this.setResponsePage((IRequestablePage)new ResourceConfigurationPage(layerInfo, true));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to create feature type", e);
            this.error((Serializable)((Object)new ParamResourceModel("creationFailure", (Component)this, e.getMessage()).getString()));
        }
    }

    @Override
    protected void onCancel() {
        this.doReturn(LayerPage.class);
    }

    private DropDownChoice<StoredQuery> storedQueriesDropDown() {
        final DropDownChoice dropdown = new DropDownChoice("storedQueriesDropDown", (IModel)new Model(), (IModel)new StoredQueryListModel(), (IChoiceRenderer)new StoredQueryListRenderer());
        dropdown.setRequired(true);
        dropdown.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -7195159596309736905L;

            protected void onUpdate(AjaxRequestTarget target) {
                StoredQuery selection = (StoredQuery)dropdown.getDefaultModelObject();
                CascadedWFSStoredQueryNewPage.this.parameterProvider.refreshItems(selection.storedQueryId);
                target.add(new Component[]{CascadedWFSStoredQueryNewPage.this.parameters});
            }
        }});
        return dropdown;
    }

    class ViewNameValidator
    implements IValidator<String> {
        private static final long serialVersionUID = 8023559657640603820L;

        ViewNameValidator() {
        }

        public void validate(IValidatable<String> validatable) {
            String csqName = (String)validatable.getValue();
            DataStoreInfo store = (DataStoreInfo)CascadedWFSStoredQueryNewPage.this.getCatalog().getStore(CascadedWFSStoredQueryNewPage.this.storeId, DataStoreInfo.class);
            List ftis = CascadedWFSStoredQueryNewPage.this.getCatalog().getResourcesByStore((StoreInfo)store, FeatureTypeInfo.class);
            for (FeatureTypeInfo curr : ftis) {
                StoredQueryConfiguration config = (StoredQueryConfiguration)curr.getMetadata().get("WFS_NG_STORED_QUERY_CONFIGURATION", StoredQueryConfiguration.class);
                if (config == null || !curr.getNativeName().equals(csqName)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", csqName);
                map.put("dataStore", store.getName());
                ValidationError err = new ValidationError("duplicateSqlViewName").addKey("duplicateSqlViewName").setVariables(map);
                validatable.error((IValidationError)err);
                return;
            }
        }
    }

    public static class StoredQuery
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String title;
        private String storedQueryId;

        public void setStoredQueryId(String storedQueryId) {
            this.storedQueryId = storedQueryId;
        }

        public String getStoredQueryId() {
            return this.storedQueryId;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }

    private class StoredQueryListRenderer
    extends ChoiceRenderer<StoredQuery> {
        private static final long serialVersionUID = 7539702994237874704L;

        private StoredQueryListRenderer() {
        }

        public Object getDisplayValue(StoredQuery object) {
            return object.getTitle();
        }

        public String getIdValue(StoredQuery object, int index) {
            return object.getStoredQueryId();
        }
    }

    private class StoredQueryListModel
    extends LoadableDetachableModel<List<StoredQuery>> {
        private static final long serialVersionUID = 2434460260811775002L;

        private StoredQueryListModel() {
        }

        protected List<StoredQuery> load() {
            ArrayList<StoredQuery> ret = new ArrayList<StoredQuery>();
            for (StoredQueryListItemType sqlit : CascadedWFSStoredQueryNewPage.this.listStoredQueries()) {
                StoredQuery item = new StoredQuery();
                item.setStoredQueryId(sqlit.getId());
                item.setTitle(CascadedWFSStoredQueryAbstractPage.createStoredQueryTitle(sqlit));
                ret.add(item);
            }
            return ret;
        }
    }
}

