/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.importer;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.importer.LayerResource;
import org.geoserver.web.data.importer.WMTSLayerProvider;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class WMTSLayerImporterPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = -3413451886777414860L;
    String storeId;
    private GeoServerTablePanel<LayerResource> layers;
    private WMTSLayerProvider provider;
    int importCount;
    int errorCount;
    int updateCount;
    private Form<WMTSLayerImporterPage> form;

    public WMTSLayerImporterPage(PageParameters params) {
        this.storeId = params.get("storeId").toString();
        WMTSStoreInfo store = (WMTSStoreInfo)this.getCatalog().getStore(this.storeId, WMTSStoreInfo.class);
        this.provider = new WMTSLayerProvider();
        this.provider.setStoreId(this.storeId);
        if (this.provider.size() <= 0L) {
            this.error((Serializable)((Object)new ParamResourceModel("storeEmpty", (Component)this, store.getName(), store.getWorkspace().getName()).getString()));
        }
        this.form = new Form("form", (IModel)new CompoundPropertyModel((Object)this));
        this.form.setOutputMarkupId(true);
        this.add(new Component[]{this.form});
        this.layers = new GeoServerTablePanel<LayerResource>("layerChooser", (GeoServerDataProvider)this.provider, true){
            private static final long serialVersionUID = -5817898784100419973L;

            @Override
            protected Component getComponentForProperty(String id, IModel<LayerResource> itemModel, GeoServerDataProvider.Property<LayerResource> property) {
                if (property == WMTSLayerProvider.NAME) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property == WMTSLayerProvider.STATUS) {
                    Fragment f = new Fragment(id, "labelIcon", (MarkupContainer)WMTSLayerImporterPage.this);
                    f.add(new Component[]{new Image("icon", (IModel)new IconModel(itemModel))});
                    f.add(new Component[]{new Label("label", (IModel)new StatusModel(itemModel))});
                    return f;
                }
                if (property == WMTSLayerProvider.ACTION) {
                    LayerResource resource = (LayerResource)itemModel.getObject();
                    LayerResource.LayerStatus status = resource.getStatus();
                    if (status == LayerResource.LayerStatus.PUBLISHED || status == LayerResource.LayerStatus.NEWLY_PUBLISHED || status == LayerResource.LayerStatus.UPDATED) {
                        return WMTSLayerImporterPage.this.resourceChooserLink(id, itemModel, (IModel<?>)new ParamResourceModel("NewLayerPage.publishAgain", (Component)this, new Object[0]));
                    }
                    return WMTSLayerImporterPage.this.resourceChooserLink(id, itemModel, (IModel<?>)new ParamResourceModel("NewLayerPage.publish", (Component)this, new Object[0]));
                }
                return null;
            }
        };
        this.layers.setItemReuseStrategy(DefaultItemReuseStrategy.getInstance());
        this.layers.setFilterable(true);
        this.form.add(new Component[]{this.layers});
        AjaxSubmitLink submitLink = this.submitLink();
        this.form.add(new Component[]{submitLink});
        this.form.add(new Component[]{this.importAllLink()});
    }

    SimpleAjaxLink<LayerResource> resourceChooserLink(String id, IModel<LayerResource> itemModel, IModel<?> label) {
        return new SimpleAjaxLink<LayerResource>(id, itemModel, label){
            private static final long serialVersionUID = 163167608296661157L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                LayerResource resource = (LayerResource)this.getDefaultModelObject();
                this.setResponsePage((IRequestablePage)new ResourceConfigurationPage(WMTSLayerImporterPage.this.buildLayerInfo(resource), true));
            }
        };
    }

    LayerInfo buildLayerInfo(LayerResource resource) {
        Catalog catalog = this.getCatalog();
        StoreInfo store = catalog.getStore(this.storeId, StoreInfo.class);
        try {
            CatalogBuilder builder = new CatalogBuilder(catalog);
            builder.setStore(store);
            WMTSLayerInfo wli = builder.buildWMTSLayer(resource.getLocalName());
            return builder.buildLayer((ResourceInfo)wli);
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while building the resources for the configuration page", e);
        }
    }

    AjaxSubmitLink submitLink() {
        return new AjaxSubmitLink("import"){
            private static final long serialVersionUID = -7161320029912723242L;

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    List<LayerResource> selection = WMTSLayerImporterPage.this.layers.getSelection();
                    if (selection.isEmpty()) {
                        this.error((Serializable)((Object)new ParamResourceModel("selectionEmpty", (Component)WMTSLayerImporterPage.this, new Object[0]).getString()));
                    } else {
                        WMTSLayerImporterPage.this.publishLayers(selection);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while setting up mass import", e);
                }
                target.add(new Component[]{WMTSLayerImporterPage.this.form});
                WMTSLayerImporterPage.this.addFeedbackPanels(target);
            }
        };
    }

    void publishLayers(List<LayerResource> selection) {
        Catalog catalog = this.getCatalog();
        CatalogBuilder builder = new CatalogBuilder(catalog);
        WMTSStoreInfo store = (WMTSStoreInfo)this.getCatalog().getStore(this.storeId, WMTSStoreInfo.class);
        builder.setStore((StoreInfo)store);
        this.importCount = 0;
        this.errorCount = 0;
        this.updateCount = 0;
        for (LayerResource resource : selection) {
            this.publishLayer(resource, builder, store, catalog);
        }
        this.createImportReport();
        this.layers.reset();
        this.provider.updateLayerOrder();
    }

    AjaxSubmitLink importAllLink() {
        return new AjaxSubmitLink("importAll"){
            private static final long serialVersionUID = 7089389540839181808L;

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    WMTSLayerImporterPage.this.publishLayers(WMTSLayerImporterPage.this.provider.getItems());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while setting up mass import", e);
                }
                target.add(new Component[]{WMTSLayerImporterPage.this.form});
                WMTSLayerImporterPage.this.addFeedbackPanels(target);
            }
        };
    }

    private void publishLayer(LayerResource layer, CatalogBuilder builder, WMTSStoreInfo store, Catalog catalog) {
        LayerInfo li;
        WMTSLayerInfo wli;
        try {
            wli = builder.buildWMTSLayer(layer.getLocalName());
            li = builder.buildLayer((ResourceInfo)wli);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error building WMTS cascading layer " + layer.getLocalName(), e);
            layer.setStatus(LayerResource.LayerStatus.ERROR);
            layer.setError(e.getMessage());
            ++this.errorCount;
            return;
        }
        WMTSLayerInfo exists = (WMTSLayerInfo)catalog.getResourceByStore((StoreInfo)store, li.getName(), WMTSLayerInfo.class);
        if (exists != null) {
            builder.updateWMTSLayer(exists, wli);
            layer.setStatus(LayerResource.LayerStatus.UPDATED);
            ++this.updateCount;
        } else {
            try {
                catalog.add((ResourceInfo)wli);
                catalog.add(li);
                layer.setStatus(LayerResource.LayerStatus.NEWLY_PUBLISHED);
                ++this.importCount;
            }
            catch (Exception e) {
                catalog.remove((ResourceInfo)wli);
                LOGGER.log(Level.WARNING, "Error auto configuring WMTS cascading layer " + li.getName(), e);
                layer.setStatus(LayerResource.LayerStatus.ERROR);
                layer.setError(e.getMessage());
                ++this.errorCount;
            }
        }
    }

    private void createImportReport() {
        if (this.importCount > 0) {
            this.info((Serializable)((Object)("Succesfully imported " + this.importCount + " layers")));
        } else {
            this.info((Serializable)((Object)"No new layers were imported"));
        }
        if (this.updateCount > 0) {
            this.info((Serializable)((Object)("Updated " + this.updateCount + " layers")));
        }
        if (this.errorCount > 0) {
            this.error((Serializable)((Object)("Unable to import " + this.errorCount + " layers, you may want to import them manually")));
        }
    }

    final class IconModel
    implements IModel<PackageResourceReference> {
        private static final long serialVersionUID = 5762710251083186192L;
        IModel<LayerResource> layerResource;

        public IconModel(IModel<LayerResource> layerResource) {
            this.layerResource = layerResource;
        }

        public PackageResourceReference getObject() {
            LayerResource resource = (LayerResource)this.layerResource.getObject();
            if (resource.getStatus() == LayerResource.LayerStatus.ERROR) {
                return new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/error.png");
            }
            if (resource.getStatus() == LayerResource.LayerStatus.NEW) {
                return new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/add.png");
            }
            if (resource.getStatus() == LayerResource.LayerStatus.NEWLY_PUBLISHED) {
                return CatalogIconFactory.ENABLED_ICON;
            }
            if (resource.getStatus() == LayerResource.LayerStatus.UPDATED) {
                return new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/pencil.png");
            }
            if (resource.getStatus() == LayerResource.LayerStatus.PUBLISHED) {
                return CatalogIconFactory.MAP_ICON;
            }
            return null;
        }

        public void setObject(PackageResourceReference object) {
            throw new UnsupportedOperationException();
        }
    }

    final class StatusModel
    implements IModel<String> {
        private static final long serialVersionUID = 7754149365712750847L;
        IModel<LayerResource> layerResource;

        public StatusModel(IModel<LayerResource> layerResource) {
            this.layerResource = layerResource;
        }

        public String getObject() {
            LayerResource resource = (LayerResource)this.layerResource.getObject();
            return new ParamResourceModel("WMTSLayerImporterPage.status." + resource.getStatus(), (Component)WMTSLayerImporterPage.this, resource.getError()).getString();
        }

        public void setObject(String object) {
            throw new UnsupportedOperationException();
        }
    }
}

