/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.include.Include;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.template.TemplateUtils;
import org.geotools.util.logging.Logging;

public class LoginFormHTMLInclude
extends Include {
    protected static final Logger LOGGER = Logging.getLogger(LoginFormHTMLInclude.class);
    private static final long serialVersionUID = 2413413223248385722L;
    private static final String DEFAULT_AUTOCOMPLETE_VALUE = "on";
    public static final String GEOSERVER_LOGIN_AUTOCOMPLETE = "geoserver.login.autocomplete";
    private static final Configuration templateConfig = TemplateUtils.getSafeConfiguration(null, null, (Integer)3);
    private PackageResourceReference resourceReference;

    public LoginFormHTMLInclude(String id, PackageResourceReference packageResourceReference) {
        super(id);
        this.resourceReference = packageResourceReference;
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        String content = this.importAsString();
        this.replaceComponentTagBody(markupStream, openTag, content);
    }

    protected String importAsString() {
        if (this.resourceReference != null) {
            try {
                templateConfig.setClassForTemplateLoading(this.resourceReference.getScope(), "");
                Template template = templateConfig.getTemplate(this.resourceReference.getName());
                HashMap<String, String> params = new HashMap<String, String>();
                String autocompleteValue = GeoServerExtensions.getProperty((String)GEOSERVER_LOGIN_AUTOCOMPLETE);
                if (autocompleteValue == null) {
                    autocompleteValue = DEFAULT_AUTOCOMPLETE_VALUE;
                }
                params.put("autocomplete", autocompleteValue);
                StringWriter writer = new StringWriter();
                template.process(params, (Writer)writer);
                return writer.toString();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Problem reading resource contents.", ex);
            }
        }
        return "";
    }
}

