/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geotools.util.GrowableInternationalString;

public class GrowableStringModel
extends ChainingModel<GrowableInternationalString> {
    PropertyModel<Map<Locale, String>> growableMapModel;

    public GrowableStringModel(IModel<GrowableInternationalString> model) {
        super(model);
        this.growableMapModel = new PropertyModel(model, "localMap");
    }

    public List<InternationalStringEntry> getEntries() {
        Map map = (Map)this.growableMapModel.getObject();
        ArrayList<InternationalStringEntry> result = new ArrayList<InternationalStringEntry>(map.size());
        for (Locale locale : map.keySet()) {
            String text = (String)map.get(locale);
            result.add(new InternationalStringEntry(locale, text));
        }
        return result;
    }

    public void setObject(GrowableInternationalString object) {
        this.growableMapModel = new PropertyModel((Object)object, "localMap");
        super.setObject((Object)object);
    }

    public static final class InternationalStringEntry
    implements Serializable {
        private Locale locale;
        private String text;

        public InternationalStringEntry() {
        }

        public InternationalStringEntry(Locale locale, String text) {
            this.locale = locale;
            this.text = text;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

