/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.function.Supplier;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.NoCrypt;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.web.GeoServerApplication;

class GeoServerCryptProvider
implements Supplier<ICrypt> {
    GeoServerSecurityManager manager;
    volatile ICrypt theCrypt;

    public GeoServerCryptProvider(GeoServerSecurityManager manager) {
        this.manager = manager;
    }

    @Override
    public ICrypt get() {
        if (this.manager.isEncryptingUrlParams()) {
            return this.getCrypt();
        }
        return new NoCrypt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICrypt getCrypt() {
        if (this.theCrypt == null) {
            GeoServerCryptProvider geoServerCryptProvider = this;
            synchronized (geoServerCryptProvider) {
                if (this.theCrypt == null) {
                    GeoServerApplication application = GeoServerApplication.get();
                    this.theCrypt = application.getSecuritySettings().getCryptFactory().newCrypt();
                }
            }
        }
        return this.theCrypt;
    }
}

