/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.rest.exception.RestException;
import org.geowebcache.util.ServletUtils;
import org.springframework.http.HttpStatus;

public class ZipFilterUpdate {
    private static Logger log = Logging.getLogger((String)ZipFilterUpdate.class.getName());
    InputStream is;

    public ZipFilterUpdate(InputStream is) {
        this.is = is;
    }

    public void runUpdate(RequestFilter filter, TileLayer tl) throws RestException {
        try (ZipInputStream zis = new ZipInputStream(this.is);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                log.info("Reading " + ze.getName() + " (" + ze.getSize() + " bytes ) for " + filter.getName());
                if (ze.isDirectory()) {
                    throw new RestException("Zip file cannot contain directories.", HttpStatus.BAD_REQUEST);
                }
                String[] parsedName = this.parseName(ze.getName());
                byte[] data = ServletUtils.readStream((InputStream)zis, (int)16384, (int)1500, (boolean)false);
                try {
                    filter.update(data, tl, parsedName[0], Integer.parseInt(parsedName[1]));
                }
                catch (GeoWebCacheException e) {
                    throw new RestException("Error updating " + filter.getName() + ": " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
                }
                ze = zis.getNextEntry();
            }
        }
        catch (IOException ioe) {
            throw new RestException("IOException while reading zip, " + ioe.getMessage(), HttpStatus.BAD_REQUEST);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException iOException) {}
        }
    }

    String[] parseName(String fileName) throws RestException {
        String[] strs = fileName.split("_");
        String[] zExt = strs[2].split("\\.");
        strs[2] = zExt[0];
        String[] gridSetIdZ = new String[]{strs[1], strs[2]};
        return gridSetIdZ;
    }
}

