/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.net.URI;
import java.util.Collection;
import org.geowebcache.rest.controller.GWCController;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.springframework.web.util.UriComponents;

public class XStreamListAliasWrapper {
    Collection<String> object;
    String alias;
    Class<? extends Collection> collectionClass;
    Class<? extends GWCController> controllerClass;

    public XStreamListAliasWrapper(Collection<String> object, String alias, Class<? extends Collection> collectionClass, Class<? extends GWCController> controllerClass) {
        this.object = object;
        this.alias = alias;
        this.collectionClass = collectionClass;
        this.controllerClass = controllerClass;
    }

    public Converter createConverter() {
        return new Converter(){

            public boolean canConvert(Class type) {
                return XStreamListAliasWrapper.this.collectionClass.isAssignableFrom(type);
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                Collection entries = (Collection)source;
                for (String name : entries) {
                    writer.startNode(XStreamListAliasWrapper.this.alias);
                    writer.startNode("name");
                    writer.setValue(name);
                    writer.endNode();
                    writer.startNode("atom:link");
                    writer.addAttribute("xmlns:atom", "http://www.w3.org/2005/Atom");
                    writer.addAttribute("rel", "alternate");
                    UriComponents uriComponents = MvcUriComponentsBuilder.fromMethodName(XStreamListAliasWrapper.this.controllerClass, (String)(XStreamListAliasWrapper.this.alias + "Get"), (Object[])new Object[]{name}).buildAndExpand(new Object[]{""});
                    String normalizedLayerUri = URI.create(uriComponents.encode().toUriString().replace("$", "")).normalize().toASCIIString();
                    writer.addAttribute("href", normalizedLayerUri + ".xml");
                    writer.addAttribute("type", MediaType.TEXT_XML.toString());
                    writer.endNode();
                    writer.endNode();
                }
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

