/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.rest.exception.RestException;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

@ControllerAdvice
public class RestExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(RestExceptionHandler.class.getName());

    @ExceptionHandler(value={RestException.class})
    public void handleRestException(RestException e, HttpServletResponse response, WebRequest request, OutputStream os) throws IOException {
        LOGGER.log(Level.SEVERE, e.getMessage(), e);
        response.setStatus(e.getStatus().value());
        response.setContentType("text/plain");
        StreamUtils.copy((String)e.getMessage(), (Charset)StandardCharsets.UTF_8, (OutputStream)os);
    }
}

