/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.rest.controller.GWCController;
import org.geowebcache.rest.exception.RestException;
import org.geowebcache.util.ApplicationContextProvider;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.WebApplicationContext;

public abstract class GWCSeedingController
extends GWCController {
    public JSONObject myrequest;
    private WebApplicationContext context;

    @Autowired
    public GWCSeedingController(ApplicationContextProvider appCtx) {
        this.context = appCtx == null ? null : appCtx.getApplicationContext();
    }

    public abstract ResponseEntity<?> doGet(HttpServletRequest var1) throws RestException;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws RestException, IOException {
        String formatExtension = req.getParameter("extension");
        XStream xs = this.configXStream((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new DomDriver()));
        Object obj = null;
        if (formatExtension == null || formatExtension.equalsIgnoreCase("xml")) {
            obj = xs.fromXML((InputStream)req.getInputStream());
        } else if (formatExtension.equalsIgnoreCase("json")) {
            obj = xs.fromXML(this.convertJson(req.getInputStream().toString()));
        } else {
            throw new RestException("Format extension unknown or not specified: " + formatExtension, HttpStatus.BAD_REQUEST);
        }
        this.handleRequest(req, resp, obj);
    }

    protected abstract void handleRequest(HttpServletRequest var1, HttpServletResponse var2, Object var3);

    protected String convertJson(String entityText) throws IOException {
        JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
        try (StringReader reader = new StringReader(entityText);){
            String string;
            try (StringWriter writer = new StringWriter();){
                HierarchicalStreamReader hsr = driver.createReader((Reader)reader);
                new HierarchicalStreamCopier().copy(hsr, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
                string = writer.toString();
            }
            return string;
        }
    }

    public void setContext(WebApplicationContext context) {
        this.context = context;
    }

    protected XStream configXStream(XStream xs) {
        return XMLConfiguration.getConfiguredXStreamWithContext((XStream)xs, (WebApplicationContext)this.context, (ContextualConfigurationProvider.Context)ContextualConfigurationProvider.Context.REST);
    }
}

