/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.rest.config.XMLConfiguration;
import org.geowebcache.rest.controller.GWCController;
import org.geowebcache.rest.exception.RestException;
import org.geowebcache.rest.filter.XmlFilterUpdate;
import org.geowebcache.rest.filter.ZipFilterUpdate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}/rest"})
public class FilterUpdateController
extends GWCController {
    @Autowired
    TileLayerDispatcher tld;

    @RequestMapping(value={"/filter/{filterName}/update/{updateType}"}, method={RequestMethod.POST})
    public ResponseEntity<?> doPost(HttpServletRequest request, @PathVariable String filterName, @PathVariable String updateType) {
        block7: {
            Iterator lIter = this.tld.getLayerList().iterator();
            RequestFilter filter = null;
            TileLayer tl = null;
            while (lIter.hasNext() && filter == null) {
                tl = (TileLayer)lIter.next();
                List filters = tl.getRequestFilters();
                if (filters == null) continue;
                Iterator fIter = filters.iterator();
                while (fIter.hasNext() && filter == null) {
                    RequestFilter cFilter = (RequestFilter)fIter.next();
                    if (!cFilter.getName().equals(filterName)) continue;
                    filter = cFilter;
                }
            }
            if (filter == null) {
                throw new RestException("No filter by the name " + filterName + " was found.", HttpStatus.BAD_REQUEST);
            }
            try {
                if (updateType.equalsIgnoreCase("xml")) {
                    ServletInputStream input = request.getInputStream();
                    XmlFilterUpdate fu = XMLConfiguration.parseXMLFilterUpdate((InputStream)input);
                    fu.runUpdate(filter, tl);
                    break block7;
                }
                if (updateType.equalsIgnoreCase("zip")) {
                    ZipFilterUpdate fu = new ZipFilterUpdate((InputStream)request.getInputStream());
                    fu.runUpdate(filter, tl);
                    break block7;
                }
                throw new RestException("Unknow update type " + updateType + "\n", HttpStatus.BAD_REQUEST);
            }
            catch (IOException e) {
                throw new RestException("Internal Error", HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)"Filter update completed, no problems encountered.\n", (MultiValueMap)headers, HttpStatus.OK);
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.tld = tileLayerDispatcher;
    }
}

