#!/usr/bin/env pytest
###############################################################################
#
# Project:  GDAL/OGR Test Suite
# Purpose:  Test MFF driver
# Author:   Even Rouault, <even dot rouault at spatialys.com>
#
###############################################################################
# Copyright (c) 2009, Even Rouault <even dot rouault at spatialys.com>
#
# SPDX-License-Identifier: MIT
###############################################################################

import gdaltest
import pytest

pytestmark = pytest.mark.require_driver("MFF")

###############################################################################
# Test reading a - fake - MFF dataset


def test_mff_1():

    tst = gdaltest.GDALTest("MFF", "mff/fakemff.hdr", 1, 1)
    tst.testOpen()


###############################################################################
# Test reading a - fake - tiled MFF dataset


def test_mff_2():

    tst = gdaltest.GDALTest("MFF", "mff/fakemfftiled.hdr", 1, 1)
    tst.testOpen()


###############################################################################
# Test reading a MFF file generated by CreateCopy()


def test_mff_3():

    tst = gdaltest.GDALTest("MFF", "mff/bytemff.hdr", 1, 4672)
    tst.testOpen()
